/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.elasticsearch.ElasticsearchConnectorConfig;
import com.facebook.presto.elasticsearch.ElasticsearchRecordSet;
import com.facebook.presto.elasticsearch.ElasticsearchSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ElasticsearchRecordSetProvider
implements ConnectorRecordSetProvider {
    private final ElasticsearchConnectorConfig config;

    @Inject
    public ElasticsearchRecordSetProvider(ElasticsearchConnectorConfig config) {
        this.config = Objects.requireNonNull(config, "config is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        Objects.requireNonNull(split, "split is null");
        ElasticsearchSplit elasticsearchSplit = (ElasticsearchSplit)split;
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)((ElasticsearchColumnHandle)columnHandle));
        }
        return new ElasticsearchRecordSet(elasticsearchSplit, this.config, (List<ElasticsearchColumnHandle>)handles.build());
    }
}

