/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class ElasticsearchSplit
implements ConnectorSplit {
    private final String index;
    private final String type;
    private final int shard;
    private final String searchNode;
    private final int port;
    private final TupleDomain<ColumnHandle> tupleDomain;

    @JsonCreator
    public ElasticsearchSplit(@JsonProperty(value="index") String index, @JsonProperty(value="type") String type, @JsonProperty(value="shard") int shard, @JsonProperty(value="searchNode") String searchNode, @JsonProperty(value="port") int port, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain) {
        this.index = Objects.requireNonNull(index, "index is null");
        this.type = Objects.requireNonNull(type, "index is null");
        this.searchNode = Objects.requireNonNull(searchNode, "searchNode is null");
        this.port = port;
        this.shard = shard;
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
    }

    @JsonProperty
    public String getIndex() {
        return this.index;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public int getShard() {
        return this.shard;
    }

    @JsonProperty
    public String getSearchNode() {
        return this.searchNode;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return ImmutableList.of((Object)HostAddress.fromParts((String)this.searchNode, (int)this.port));
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.index).addValue((Object)this.type).addValue(this.shard).addValue(this.port).addValue((Object)this.searchNode).addValue(this.tupleDomain).toString();
    }
}

