/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.elasticsearch.ElasticsearchClient;
import com.facebook.presto.elasticsearch.ElasticsearchSplit;
import com.facebook.presto.elasticsearch.ElasticsearchTableDescription;
import com.facebook.presto.elasticsearch.ElasticsearchTableHandle;
import com.facebook.presto.elasticsearch.ElasticsearchTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;

public class ElasticsearchSplitManager
implements ConnectorSplitManager {
    private final ElasticsearchClient client;

    @Inject
    public ElasticsearchSplitManager(ElasticsearchClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        ElasticsearchTableLayoutHandle layoutHandle = (ElasticsearchTableLayoutHandle)layout;
        ElasticsearchTableHandle tableHandle = layoutHandle.getTable();
        ElasticsearchTableDescription table = this.client.getTable(tableHandle.getSchemaName(), tableHandle.getTableName());
        Verify.verify((table != null ? 1 : 0) != 0, (String)"Table no longer exists: %s", (Object)tableHandle.toString());
        List<String> indices = this.client.getIndices(table);
        ImmutableList.Builder splits = ImmutableList.builder();
        for (String index : indices) {
            ClusterSearchShardsResponse response = this.client.getSearchShards(index, table);
            DiscoveryNode[] nodes = response.getNodes();
            for (ClusterSearchShardsGroup group : response.getGroups()) {
                int nodeIndex = group.getShardId().getId() % nodes.length;
                ElasticsearchSplit split = new ElasticsearchSplit(index, table.getType(), group.getShardId().getId(), nodes[nodeIndex].getHostName(), nodes[nodeIndex].getAddress().getPort(), layoutHandle.getTupleDomain());
                splits.add((Object)split);
            }
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

