/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.elasticsearch.ElasticsearchColumn;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ElasticsearchTableDescription {
    private final String tableName;
    private final String schemaName;
    private final String host;
    private final int port;
    private final String clusterName;
    private final String index;
    private final boolean indexExactMatch;
    private final String type;
    private final Optional<List<ElasticsearchColumn>> columns;

    @JsonCreator
    public ElasticsearchTableDescription(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="host") String host, @JsonProperty(value="port") int port, @JsonProperty(value="clusterName") String clusterName, @JsonProperty(value="index") String index, @JsonProperty(value="indexExactMatch") boolean indexExactMatch, @JsonProperty(value="type") String type, @JsonProperty(value="columns") Optional<List<ElasticsearchColumn>> columns) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (Object)"tableName is null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schemaName) ? 1 : 0) != 0, (Object)"schemaName is null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)host) ? 1 : 0) != 0, (Object)"host is null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clusterName) ? 1 : 0) != 0, (Object)"clusterName is null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index is null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type is null or empty");
        Objects.requireNonNull(columns, "columns is null");
        this.tableName = tableName;
        this.schemaName = schemaName;
        this.host = host;
        this.port = port;
        this.clusterName = clusterName;
        this.index = index;
        this.indexExactMatch = indexExactMatch;
        this.type = type;
        this.columns = columns;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public String getClusterName() {
        return this.clusterName;
    }

    @JsonProperty
    public String getIndex() {
        return this.index;
    }

    @JsonProperty
    public boolean getIndexExactMatch() {
        return this.indexExactMatch;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<List<ElasticsearchColumn>> getColumns() {
        return this.columns;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("schemaName", (Object)this.schemaName).add("host", (Object)this.host).add("port", this.port).add("clusterName", (Object)this.clusterName).add("index", (Object)this.index).add("indexExactMatch", this.indexExactMatch).add("type", (Object)this.type).add("columns", this.columns).toString();
    }
}

