/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.elasticsearch.ElasticsearchConnectorConfig;
import com.facebook.presto.elasticsearch.ElasticsearchTableDescription;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class ElasticsearchTableDescriptionProvider {
    private final Map<SchemaTableName, ElasticsearchTableDescription> tableDefinitions;

    @Inject
    ElasticsearchTableDescriptionProvider(ElasticsearchConnectorConfig config, JsonCodec<ElasticsearchTableDescription> codec) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(codec, "codec is null");
        this.tableDefinitions = this.createTableDescriptions(config, codec);
    }

    private Map<SchemaTableName, ElasticsearchTableDescription> createTableDescriptions(ElasticsearchConnectorConfig config, JsonCodec<ElasticsearchTableDescription> codec) {
        Optional<File[]> files = ElasticsearchTableDescriptionProvider.listFiles(config.getTableDescriptionDirectory());
        if (!files.isPresent()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (File file : files.get()) {
            ElasticsearchTableDescription table;
            if (!file.isFile() || !file.getName().endsWith(".json")) continue;
            try {
                table = (ElasticsearchTableDescription)codec.fromJson(Files.readAllBytes(file.toPath()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String schemaName = (String)MoreObjects.firstNonNull((Object)table.getSchemaName(), (Object)config.getDefaultSchema());
            builder.put((Object)new SchemaTableName(schemaName, table.getTableName()), (Object)table);
        }
        return builder.build();
    }

    private static Optional<File[]> listFiles(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return Optional.empty();
        }
        return Optional.ofNullable(directory.listFiles());
    }

    public ElasticsearchTableDescription get(SchemaTableName schemaTableName) {
        return this.tableDefinitions.get(schemaTableName);
    }

    public Set<SchemaTableName> getAllSchemaTableNames() {
        return this.tableDefinitions.keySet();
    }

    public Set<ElasticsearchTableDescription> getAllTableDescriptions() {
        return ImmutableSet.copyOf(this.tableDefinitions.values());
    }
}

