/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import java.util.Locale;
import java.util.Objects;

public final class ElasticsearchTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName schemaTableName;

    @JsonCreator
    public ElasticsearchTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.schemaTableName = new SchemaTableName(schemaName.toLowerCase(Locale.ENGLISH), tableName.toLowerCase(Locale.ENGLISH));
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaTableName.getSchemaName();
    }

    @JsonProperty
    public String getTableName() {
        return this.schemaTableName.getTableName();
    }

    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public int hashCode() {
        return Objects.hash(this.getSchemaName(), this.getTableName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElasticsearchTableHandle other = (ElasticsearchTableHandle)obj;
        return Objects.equals(this.getSchemaName(), other.getSchemaName()) && Objects.equals(this.getTableName(), other.getTableName());
    }

    public String toString() {
        return Joiner.on((String)":").join((Object)this.getSchemaName(), (Object)this.getTableName(), new Object[0]);
    }
}

