/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ElasticsearchUtils {
    private ElasticsearchUtils() {
    }

    public static Block serializeObject(Type type, BlockBuilder builder, Object object) {
        if ("row".equals(type.getTypeSignature().getBase())) {
            return ElasticsearchUtils.serializeStruct(type, builder, object);
        }
        if ("map".equals(type.getTypeSignature().getBase()) || "array".equals(type.getTypeSignature().getBase())) {
            throw new IllegalArgumentException("Type not supported: " + type.getDisplayName());
        }
        ElasticsearchUtils.serializePrimitive(type, builder, object);
        return null;
    }

    private static Block serializeStruct(Type type, BlockBuilder builder, Object object) {
        if (object == null) {
            Objects.requireNonNull(builder, "builder is null");
            builder.appendNull();
            return null;
        }
        List typeParameters = type.getTypeParameters();
        boolean builderSynthesized = false;
        if (builder == null) {
            builderSynthesized = true;
            builder = type.createBlockBuilder(null, 1);
        }
        BlockBuilder currentBuilder = builder.beginBlockEntry();
        for (int i = 0; i < typeParameters.size(); ++i) {
            Optional fieldName = ((TypeSignatureParameter)type.getTypeSignature().getParameters().get(i)).getNamedTypeSignature().getName();
            String name = "";
            if (fieldName.isPresent()) {
                name = ((String)fieldName.get()).toLowerCase(Locale.ENGLISH);
            }
            Object value = ((Map)object).get(name);
            ElasticsearchUtils.serializeObject((Type)typeParameters.get(i), currentBuilder, value);
        }
        builder.closeEntry();
        if (builderSynthesized) {
            return (Block)type.getObject((Block)builder, 0);
        }
        return null;
    }

    private static void serializePrimitive(Type type, BlockBuilder builder, Object object) {
        Objects.requireNonNull(builder, "builder is null");
        if (object == null) {
            builder.appendNull();
            return;
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            type.writeBoolean(builder, ((Boolean)object).booleanValue());
        } else if (type.equals(BigintType.BIGINT)) {
            type.writeLong(builder, ((Long)object).longValue());
        } else if (type.equals(DoubleType.DOUBLE)) {
            type.writeDouble(builder, ((Double)object).doubleValue());
        } else if (type.equals(IntegerType.INTEGER)) {
            type.writeLong(builder, (long)((Integer)object).intValue());
        } else if (type.equals(VarcharType.VARCHAR) || type.equals(VarbinaryType.VARBINARY)) {
            type.writeSlice(builder, Slices.utf8Slice((String)object.toString()));
        } else {
            throw new IllegalArgumentException("Unknown primitive type: " + type.getDisplayName());
        }
    }
}

