/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class RetryDriver {
    private static final Logger log = Logger.get(RetryDriver.class);
    private static final int DEFAULT_RETRY_ATTEMPTS = 5;
    private static final Duration DEFAULT_SLEEP_TIME = Duration.valueOf((String)"1s");
    private static final Duration DEFAULT_MAX_RETRY_TIME = Duration.valueOf((String)"10s");
    private static final double DEFAULT_SCALE_FACTOR = 2.0;
    private final int maxAttempts;
    private final Duration maxRetryTime;

    private RetryDriver(int maxAttempts, Duration maxRetryTime) {
        this.maxAttempts = maxAttempts;
        this.maxRetryTime = maxRetryTime;
    }

    private RetryDriver() {
        this(5, DEFAULT_MAX_RETRY_TIME);
    }

    public static RetryDriver retry() {
        return new RetryDriver();
    }

    public final RetryDriver maxAttempts(int maxAttempts) {
        return new RetryDriver(maxAttempts, this.maxRetryTime);
    }

    public final RetryDriver exponentialBackoff(Duration maxRetryTime) {
        return new RetryDriver(this.maxAttempts, maxRetryTime);
    }

    public <V> V run(String callableName, Callable<V> callable) throws Exception {
        Objects.requireNonNull(callableName, "callableName is null");
        Objects.requireNonNull(callable, "callable is null");
        ArrayList<Throwable> suppressedExceptions = new ArrayList<Throwable>();
        long startTime = System.nanoTime();
        int attempt = 0;
        while (true) {
            ++attempt;
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (attempt >= this.maxAttempts || Duration.nanosSince((long)startTime).compareTo(this.maxRetryTime) >= 0) {
                    RetryDriver.addSuppressed(e, suppressedExceptions);
                    throw e;
                }
                log.debug("Failed on executing %s with attempt %d, will retry. Exception: %s", new Object[]{callableName, attempt, e.getMessage()});
                suppressedExceptions.add(e);
                int delayInMs = (int)Math.min((double)DEFAULT_SLEEP_TIME.toMillis() * Math.pow(2.0, attempt - 1), (double)DEFAULT_SLEEP_TIME.toMillis());
                int jitter = ThreadLocalRandom.current().nextInt(Math.max(1, (int)((double)delayInMs * 0.1)));
                try {
                    TimeUnit.MILLISECONDS.sleep(delayInMs + jitter);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
        }
    }

    private static void addSuppressed(Exception exception, List<Throwable> suppressedExceptions) {
        for (Throwable suppressedException : suppressedExceptions) {
            if (exception == suppressedException) continue;
            exception.addSuppressed(suppressedException);
        }
    }
}

