/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.http.client.Request;
import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.PinotUtils;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PinotBrokerPageSource
implements ConnectorPageSource {
    private static final String REQUEST_PAYLOAD_TEMPLATE = "{\"pql\" : \"%s\" }";
    private static final String QUERY_URL_TEMPLATE = "http://%s/query";
    private static final String PINOT_INFINITY = "\u221e";
    private static final String PINOT_POSITIVE_INFINITY = "+\u221e";
    private static final String PINOT_NEGATIVE_INFINITY = "-\u221e";
    private static final Double PRESTO_INFINITY = Double.POSITIVE_INFINITY;
    private static final Double PRESTO_NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    private final PinotQueryGenerator.GeneratedPql brokerPql;
    private final PinotConfig pinotConfig;
    private final List<PinotColumnHandle> columnHandles;
    private final PinotClusterInfoFetcher clusterInfoFetcher;
    private final ConnectorSession session;
    private final ObjectMapper objectMapper;
    private boolean finished;
    private long readTimeNanos;
    private long completedBytes;

    public PinotBrokerPageSource(PinotConfig pinotConfig, ConnectorSession session, PinotQueryGenerator.GeneratedPql brokerPql, List<PinotColumnHandle> columnHandles, PinotClusterInfoFetcher clusterInfoFetcher, ObjectMapper objectMapper) {
        this.pinotConfig = Objects.requireNonNull(pinotConfig, "pinot config is null");
        this.brokerPql = Objects.requireNonNull(brokerPql, "broker is null");
        this.clusterInfoFetcher = Objects.requireNonNull(clusterInfoFetcher, "cluster info fetcher is null");
        this.columnHandles = ImmutableList.copyOf(columnHandles);
        this.session = Objects.requireNonNull(session, "session is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "object mapper is null");
    }

    private static Double parseDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ne) {
            switch (value) {
                case "\u221e": 
                case "+\u221e": {
                    return PRESTO_INFINITY;
                }
                case "-\u221e": {
                    return PRESTO_NEGATIVE_INFINITY;
                }
            }
            throw new PinotException(PinotErrorCode.PINOT_DECODE_ERROR, Optional.empty(), "Cannot decode double value from pinot " + value, ne);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValue(Type type, BlockBuilder blockBuilder, String value) {
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        if (!(type instanceof FixedWidthType) && !(type instanceof VarcharType)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "type '" + type + "' not supported");
        }
        if (type instanceof FixedWidthType) {
            this.completedBytes += (long)((FixedWidthType)type).getFixedSize();
            if (type instanceof BigintType) {
                type.writeLong(blockBuilder, PinotBrokerPageSource.parseDouble(value).longValue());
                return;
            } else if (type instanceof IntegerType) {
                blockBuilder.writeInt(PinotBrokerPageSource.parseDouble(value).intValue());
                return;
            } else if (type instanceof TinyintType) {
                blockBuilder.writeByte((int)PinotBrokerPageSource.parseDouble(value).byteValue());
                return;
            } else if (type instanceof SmallintType) {
                blockBuilder.writeShort((int)PinotBrokerPageSource.parseDouble(value).shortValue());
                return;
            } else if (type instanceof BooleanType) {
                type.writeBoolean(blockBuilder, Boolean.parseBoolean(value));
                return;
            } else if (type instanceof DecimalType || type instanceof DoubleType) {
                type.writeDouble(blockBuilder, PinotBrokerPageSource.parseDouble(value).doubleValue());
                return;
            } else {
                if (!(type instanceof TimestampType)) throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "type '" + type + "' not supported");
                type.writeLong(blockBuilder, Long.parseLong(value));
            }
            return;
        } else {
            Slice slice = Slices.utf8Slice((String)value);
            blockBuilder.writeBytes(slice, 0, slice.length()).closeEntry();
            this.completedBytes += (long)slice.length();
        }
    }

    private void setValuesForGroupby(List<BlockBuilder> blockBuilders, List<Type> types, int numGroupByClause, JsonNode group, String[] values) {
        int i;
        for (i = 0; i < group.size(); ++i) {
            this.setValue(types.get(i), blockBuilders.get(i), group.get(i).asText());
        }
        for (i = 0; i < values.length; ++i) {
            int metricColumnIndex = i + numGroupByClause;
            if (metricColumnIndex >= blockBuilders.size()) continue;
            this.setValue(types.get(metricColumnIndex), blockBuilders.get(metricColumnIndex), values[i]);
        }
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getNextPage() {
        if (this.finished) {
            return null;
        }
        long start = System.nanoTime();
        try {
            List expectedTypes = this.columnHandles.stream().map(PinotColumnHandle::getDataType).collect(Collectors.toList());
            PageBuilder pageBuilder = new PageBuilder(expectedTypes);
            ImmutableList.Builder columnBlockBuilders = ImmutableList.builder();
            ImmutableList.Builder columnTypes = ImmutableList.builder();
            for (int i : this.brokerPql.getExpectedColumnIndices()) {
                if (i == -1) continue;
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                columnBlockBuilders.add((Object)blockBuilder);
                columnTypes.add(expectedTypes.get(i));
            }
            int counter = this.issuePqlAndPopulate(this.brokerPql.getTable(), this.brokerPql.getPql(), this.brokerPql.getGroupByClauses(), (List<BlockBuilder>)columnBlockBuilders.build(), (List<Type>)columnTypes.build());
            pageBuilder.declarePositions(counter);
            Page page = pageBuilder.build();
            this.finished = true;
            Page page2 = page;
            return page2;
        }
        finally {
            this.readTimeNanos += System.nanoTime() - start;
        }
    }

    private int issuePqlAndPopulate(String table, String pql, int numGroupByClause, List<BlockBuilder> blockBuilders, List<Type> types) {
        return PinotUtils.doWithRetries(PinotSessionProperties.getPinotRetryCount(this.session), retryNumber -> {
            Optional<String> rpcService;
            String queryHost;
            if (this.pinotConfig.getRestProxyUrl() != null) {
                queryHost = this.pinotConfig.getRestProxyUrl();
                rpcService = Optional.ofNullable(this.pinotConfig.getRestProxyServiceForQuery());
            } else {
                queryHost = this.clusterInfoFetcher.getBrokerHost(table);
                rpcService = Optional.empty();
            }
            Request.Builder builder = Request.Builder.preparePost().setUri(URI.create(String.format(QUERY_URL_TEMPLATE, queryHost)));
            String body = this.clusterInfoFetcher.doHttpActionWithHeaders(builder, Optional.of(String.format(REQUEST_PAYLOAD_TEMPLATE, pql)), rpcService);
            return this.populateFromPqlResults(pql, numGroupByClause, blockBuilders, types, body);
        });
    }

    @VisibleForTesting
    public int populateFromPqlResults(String pql, int numGroupByClause, List<BlockBuilder> blockBuilders, List<Type> types, String body) {
        int rowCount;
        JsonNode jsonBody;
        try {
            jsonBody = this.objectMapper.readTree(body);
        }
        catch (IOException e) {
            throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), "Couldn't parse response", e);
        }
        JsonNode numServersResponded = jsonBody.get("numServersResponded");
        JsonNode numServersQueried = jsonBody.get("numServersQueried");
        if (numServersQueried == null || numServersResponded == null || numServersQueried.asInt() > numServersResponded.asInt()) {
            throw new PinotException(PinotErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE, Optional.of(pql), String.format("Only %s out of %s servers responded for query %s", numServersResponded.asInt(), numServersQueried.asInt(), pql));
        }
        JsonNode exceptions = jsonBody.get("exceptions");
        if (exceptions != null && exceptions.isArray() && exceptions.size() > 0) {
            throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.of(pql), String.format("Query %s encountered exception %s", pql, exceptions.get(0)));
        }
        JsonNode aggregationResults = jsonBody.get("aggregationResults");
        JsonNode selectionResults = jsonBody.get("selectionResults");
        if (aggregationResults != null && aggregationResults.isArray()) {
            Preconditions.checkState((aggregationResults.size() >= 1 ? 1 : 0) != 0, (Object)"Expected at least one metric to be present");
            HashMap<JsonNode, String[]> groupToValue = aggregationResults.size() == 1 || numGroupByClause == 0 ? null : new HashMap<JsonNode, String[]>();
            rowCount = 0;
            String[] singleAggregation = new String[1];
            Boolean seenGroupByResult = null;
            for (int aggregationIndex = 0; aggregationIndex < aggregationResults.size(); ++aggregationIndex) {
                JsonNode result = aggregationResults.get(aggregationIndex);
                JsonNode metricValuesForEachGroup = result.get("groupByResult");
                if (metricValuesForEachGroup != null) {
                    Preconditions.checkState((seenGroupByResult == null || seenGroupByResult != false ? 1 : 0) != 0);
                    seenGroupByResult = true;
                    Preconditions.checkState((numGroupByClause > 0 ? 1 : 0) != 0, (Object)"Expected having non zero group by clauses");
                    JsonNode groupByColumns = (JsonNode)Preconditions.checkNotNull((Object)result.get("groupByColumns"), (String)"groupByColumns missing in %s", (Object)pql);
                    if (groupByColumns.size() != numGroupByClause) {
                        throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), String.format("Expected %d gby columns but got %s instead from pinot", numGroupByClause, groupByColumns));
                    }
                    for (int groupByIndex = 0; groupByIndex < metricValuesForEachGroup.size(); ++groupByIndex) {
                        JsonNode row = metricValuesForEachGroup.get(groupByIndex);
                        JsonNode group2 = row.get("group");
                        if (group2 == null || !group2.isArray() || group2.size() != numGroupByClause) {
                            throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), String.format("Expected %d group by columns but got only a group of size %d (%s)", numGroupByClause, group2.size(), group2));
                        }
                        if (groupToValue == null) {
                            singleAggregation[0] = row.get("value").asText();
                            this.setValuesForGroupby(blockBuilders, types, numGroupByClause, group2, singleAggregation);
                            ++rowCount;
                            continue;
                        }
                        groupToValue.computeIfAbsent(group2, (Function<JsonNode, String[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$populateFromPqlResults$1(com.fasterxml.jackson.databind.JsonNode com.fasterxml.jackson.databind.JsonNode ), (Lcom/fasterxml/jackson/databind/JsonNode;)[Ljava/lang/String;)((JsonNode)aggregationResults))[aggregationIndex] = row.get("value").asText();
                    }
                    continue;
                }
                Preconditions.checkState((seenGroupByResult == null || seenGroupByResult == false ? 1 : 0) != 0);
                seenGroupByResult = false;
                Preconditions.checkState((numGroupByClause == 0 ? 1 : 0) != 0, (Object)"Expected no group by columns in pinot");
                this.setValue(types.get(aggregationIndex), blockBuilders.get(aggregationIndex), result.get("value").asText());
                rowCount = 1;
            }
            if (groupToValue != null) {
                Preconditions.checkState((rowCount == 0 ? 1 : 0) != 0, (Object)"Row count shouldn't have changed from zero");
                groupToValue.forEach((group, values) -> this.setValuesForGroupby(blockBuilders, types, numGroupByClause, (JsonNode)group, (String[])values));
                rowCount = groupToValue.size();
            }
        } else if (selectionResults != null) {
            JsonNode columns = selectionResults.get("columns");
            JsonNode results = selectionResults.get("results");
            if (columns == null || results == null || !columns.isArray() || !results.isArray() || columns.size() != blockBuilders.size()) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), String.format("Columns and results expected for %s, expected %d columns but got %d", pql, blockBuilders.size(), columns == null ? 0 : columns.size()));
            }
            for (int rowNumber = 0; rowNumber < results.size(); ++rowNumber) {
                JsonNode result = results.get(rowNumber);
                if (result == null || result.size() != blockBuilders.size()) {
                    throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), String.format("Expected row of %d columns", blockBuilders.size()));
                }
                for (int columnNumber = 0; columnNumber < blockBuilders.size(); ++columnNumber) {
                    this.setValue(types.get(columnNumber), blockBuilders.get(columnNumber), result.get(columnNumber).asText());
                }
            }
            rowCount = results.size();
        } else {
            throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), "Expected one of aggregationResults or selectionResults to be present");
        }
        Preconditions.checkState((rowCount >= 0 ? 1 : 0) != 0, (Object)"Expected row count to be initialized");
        return rowCount;
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
        this.finished = true;
    }

    private static /* synthetic */ String[] lambda$populateFromPqlResults$1(JsonNode aggregationResults, JsonNode ignored) {
        return new String[aggregationResults.size()];
    }
}

