/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotColumn;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;

public class PinotColumnUtils {
    private PinotColumnUtils() {
    }

    public static List<PinotColumn> getPinotColumnsForPinotSchema(Schema pinotTableSchema) {
        return (List)pinotTableSchema.getColumnNames().stream().filter(columnName -> !columnName.startsWith("$")).map(columnName -> new PinotColumn((String)columnName, PinotColumnUtils.getPrestoTypeFromPinotType(pinotTableSchema.getFieldSpecFor(columnName)))).collect(ImmutableList.toImmutableList());
    }

    public static Type getPrestoTypeFromPinotType(FieldSpec field) {
        if (field.isSingleValueField()) {
            return PinotColumnUtils.getPrestoTypeFromPinotType(field.getDataType());
        }
        return VarcharType.VARCHAR;
    }

    public static Type getPrestoTypeFromPinotType(FieldSpec.DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case DOUBLE: 
            case FLOAT: {
                return DoubleType.DOUBLE;
            }
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Not support type conversion for pinot data type: " + dataType);
    }
}

