/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.util.Objects;
import java.util.Optional;

public class PinotException
extends PrestoException {
    private final Optional<String> pql;
    private final PinotErrorCode pinotErrorCode;

    public PinotException(PinotErrorCode errorCode, Optional<String> pql, String message) {
        this(errorCode, pql, message, null);
    }

    public PinotException(PinotErrorCode pinotErrorCode, Optional<String> pql, String message, Throwable throwable) {
        super((ErrorCodeSupplier)Objects.requireNonNull(pinotErrorCode, "error code is null"), Objects.requireNonNull(message, "message is null"), throwable);
        this.pinotErrorCode = pinotErrorCode;
        this.pql = Objects.requireNonNull(pql, "pql is null");
    }

    public PinotErrorCode getPinotErrorCode() {
        return this.pinotErrorCode;
    }

    public String getMessage() {
        String message = super.getMessage();
        if (this.pql.isPresent()) {
            message = message + " with pql \"" + this.pql.get() + "\"";
        }
        return message;
    }
}

