/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.http.client.StringResponseHandler;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.DistributionStat;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.presto.pinot.PinotUtils;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class PinotMetricsStats {
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat requests = new CounterStat();
    private final CounterStat errorRequests = new CounterStat();
    private DistributionStat responseSize;

    public PinotMetricsStats(boolean withResponse) {
        if (withResponse) {
            this.responseSize = new DistributionStat();
        }
    }

    public void record(StringResponseHandler.StringResponse response, long duration, TimeUnit timeUnit) {
        this.time.add((double)duration, timeUnit);
        this.requests.update(1L);
        if (PinotUtils.isValidPinotHttpResponseCode(response.getStatusCode())) {
            if (this.responseSize != null) {
                this.responseSize.add((long)response.getBody().length());
            }
        } else {
            this.errorRequests.update(1L);
        }
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    @Managed
    @Nested
    public CounterStat getRequests() {
        return this.requests;
    }

    @Managed
    @Nested
    public CounterStat getErrorRequests() {
        return this.errorRequests;
    }

    @Managed
    @Nested
    public DistributionStat getResponseSize() {
        return this.responseSize;
    }
}

