/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.http.client.HttpClientBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.presto.pinot.ForPinot;
import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotConnection;
import com.facebook.presto.pinot.PinotConnector;
import com.facebook.presto.pinot.PinotConnectorPlanOptimizer;
import com.facebook.presto.pinot.PinotMetadata;
import com.facebook.presto.pinot.PinotNodePartitioningProvider;
import com.facebook.presto.pinot.PinotPageSourceProvider;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.PinotSplitManager;
import com.facebook.presto.pinot.PinotTable;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class PinotModule
implements Module {
    private final String catalogName;

    public PinotModule(String catalogName) {
        this.catalogName = catalogName;
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(PinotConfig.class);
        binder.bind(PinotConnector.class).in(Scopes.SINGLETON);
        binder.bind(PinotMetadata.class).in(Scopes.SINGLETON);
        binder.bind(PinotConnectorPlanOptimizer.class).in(Scopes.SINGLETON);
        binder.bind(PinotSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(PinotPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(PinotClusterInfoFetcher.class).in(Scopes.SINGLETON);
        binder.bind(Executor.class).annotatedWith(ForPinot.class).toInstance((Object)Executors.newSingleThreadExecutor(Threads.threadsNamed((String)("pinot-metadata-fetcher-" + this.catalogName))));
        binder.bind(PinotConnection.class).in(Scopes.SINGLETON);
        binder.bind(PinotSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(PinotNodePartitioningProvider.class).in(Scopes.SINGLETON);
        binder.bind(PinotQueryGenerator.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("pinot", ForPinot.class).withConfigDefaults(cfg -> {
            cfg.setIdleTimeout(new Duration(300.0, TimeUnit.SECONDS));
            cfg.setRequestTimeout(new Duration(300.0, TimeUnit.SECONDS));
            cfg.setMaxConnectionsPerServer(250);
            cfg.setMaxContentLength(new DataSize(32.0, DataSize.Unit.MEGABYTE));
        });
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, JsonCodec.listJsonCodec(PinotTable.class));
        PinotClusterInfoFetcher.addJsonBinders(JsonCodecBinder.jsonCodecBinder((Binder)binder));
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object)value);
            return type;
        }
    }
}

