/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public class PinotPushdownUtils {
    private PinotPushdownUtils() {
    }

    public static void checkSupported(boolean condition, String errorMessage, Object ... errorMessageArgs) {
        if (!condition) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format(errorMessage, errorMessageArgs));
        }
    }

    public static List<AggregationColumnNode> computeAggregationNodes(AggregationNode aggregationNode) {
        int groupByKeyIndex = 0;
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        for (VariableReferenceExpression outputColumn : aggregationNode.getOutputVariables()) {
            AggregationNode.Aggregation agg = (AggregationNode.Aggregation)aggregationNode.getAggregations().get(outputColumn);
            if (agg != null) {
                if (agg.getFilter().isPresent() || agg.isDistinct() || agg.getOrderBy().isPresent() || agg.getMask().isPresent()) {
                    throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Unsupported aggregation node " + aggregationNode);
                }
                nodeBuilder.add((Object)new AggregationFunctionColumnNode(outputColumn, agg.getCall()));
                continue;
            }
            VariableReferenceExpression inputColumn = (VariableReferenceExpression)aggregationNode.getGroupingKeys().get(groupByKeyIndex);
            nodeBuilder.add((Object)new GroupByColumnNode(inputColumn, outputColumn));
            ++groupByKeyIndex;
        }
        return nodeBuilder.build();
    }

    public static LinkedHashMap<VariableReferenceExpression, SortOrder> getOrderingScheme(TopNNode topNNode) {
        LinkedHashMap<VariableReferenceExpression, SortOrder> orderingScheme = new LinkedHashMap<VariableReferenceExpression, SortOrder>();
        topNNode.getOrderingScheme().getOrderByVariables().forEach(value -> orderingScheme.put((VariableReferenceExpression)value, topNNode.getOrderingScheme().getOrdering(value)));
        return orderingScheme;
    }

    private static Number decodeDecimal(BigInteger unscaledValue, DecimalType type) {
        return new BigDecimal(unscaledValue, type.getScale(), new MathContext(type.getPrecision()));
    }

    public static String getLiteralAsString(ConstantExpression node) {
        Type type = node.getType();
        if (node.getValue() == null) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Null constant expression %s with value of type %s", node, type));
        }
        if (type instanceof BooleanType) {
            return String.valueOf((Boolean)node.getValue());
        }
        if (type instanceof BigintType || type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType) {
            Number number = (Number)node.getValue();
            return String.format("%d", number.longValue());
        }
        if (type instanceof DoubleType) {
            return node.getValue().toString();
        }
        if (type instanceof RealType) {
            Long number = (Long)node.getValue();
            return String.format("%f", Float.valueOf(Float.intBitsToFloat(number.intValue())));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                Preconditions.checkState((boolean)(node.getValue() instanceof Long));
                return PinotPushdownUtils.decodeDecimal(BigInteger.valueOf((Long)node.getValue()), decimalType).toString();
            }
            Preconditions.checkState((boolean)(node.getValue() instanceof Slice));
            Slice value = (Slice)node.getValue();
            return PinotPushdownUtils.decodeDecimal(Decimals.decodeUnscaledValue((Slice)value), decimalType).toString();
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return "'" + ((Slice)node.getValue()).toStringUtf8() + "'";
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Cannot handle the constant expression %s with value of type %s", node, type));
    }

    public static abstract class AggregationColumnNode {
        private final ExpressionType expressionType;
        private final VariableReferenceExpression outputColumn;

        public AggregationColumnNode(ExpressionType expressionType, VariableReferenceExpression outputColumn) {
            this.expressionType = expressionType;
            this.outputColumn = outputColumn;
        }

        public VariableReferenceExpression getOutputColumn() {
            return this.outputColumn;
        }

        public ExpressionType getExpressionType() {
            return this.expressionType;
        }
    }

    public static class AggregationFunctionColumnNode
    extends AggregationColumnNode {
        private final CallExpression callExpression;

        public AggregationFunctionColumnNode(VariableReferenceExpression output, CallExpression callExpression) {
            super(ExpressionType.AGGREGATE, output);
            this.callExpression = callExpression;
        }

        public CallExpression getCallExpression() {
            return this.callExpression;
        }

        public String toString() {
            return this.callExpression.toString();
        }
    }

    public static class GroupByColumnNode
    extends AggregationColumnNode {
        private final VariableReferenceExpression inputColumn;

        public GroupByColumnNode(VariableReferenceExpression inputColumn, VariableReferenceExpression output) {
            super(ExpressionType.GROUP_BY, output);
            this.inputColumn = inputColumn;
        }

        public VariableReferenceExpression getInputColumn() {
            return this.inputColumn;
        }

        public String toString() {
            return this.inputColumn.toString();
        }
    }

    public static enum ExpressionType {
        GROUP_BY,
        AGGREGATE;

    }
}

