/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotScatterGatherQueryClient;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.PinotSplit;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.pinot.common.response.ServerInstance;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;

public class PinotSegmentPageSource
implements ConnectorPageSource {
    private static final Map<PinotScatterGatherQueryClient.ErrorCode, PinotErrorCode> PINOT_ERROR_CODE_MAP = ImmutableMap.of((Object)PinotScatterGatherQueryClient.ErrorCode.PINOT_UNCLASSIFIED_ERROR, (Object)((Object)PinotErrorCode.PINOT_UNCLASSIFIED_ERROR), (Object)PinotScatterGatherQueryClient.ErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE, (Object)((Object)PinotErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE), (Object)PinotScatterGatherQueryClient.ErrorCode.PINOT_INVALID_PQL_GENERATED, (Object)((Object)PinotErrorCode.PINOT_INVALID_PQL_GENERATED));
    private final List<PinotColumnHandle> columnHandles;
    private final PinotConfig pinotConfig;
    private final PinotSplit split;
    private final PinotScatterGatherQueryClient pinotQueryClient;
    private final ConnectorSession session;
    private List<Type> columnTypes;
    private LinkedList<PinotDataTableWithSize> dataTableList = new LinkedList();
    private long completedBytes;
    private long readTimeNanos;
    private long estimatedMemoryUsageInBytes;
    private PinotDataTableWithSize currentDataTable;
    private boolean closed;
    private boolean isPinotDataFetched;

    public PinotSegmentPageSource(ConnectorSession session, PinotConfig pinotConfig, PinotScatterGatherQueryClient pinotQueryClient, PinotSplit split, List<PinotColumnHandle> columnHandles) {
        this.pinotConfig = Objects.requireNonNull(pinotConfig, "pinotConfig is null");
        this.split = Objects.requireNonNull(split, "split is null");
        this.pinotQueryClient = Objects.requireNonNull(pinotQueryClient, "pinotQueryClient is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    private static void checkExceptions(DataTable dataTable, PinotSplit split) {
        Map metadata = dataTable.getMetadata();
        ArrayList exceptions = new ArrayList();
        metadata.forEach((k, v) -> {
            if (k.startsWith("Exception")) {
                exceptions.add(v);
            }
        });
        if (!exceptions.isEmpty()) {
            throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, split.getSegmentPql(), String.format("Encountered %d pinot exceptions for split %s: %s", exceptions.size(), split, exceptions));
        }
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public long getSystemMemoryUsage() {
        return this.estimatedMemoryUsageInBytes;
    }

    public boolean isFinished() {
        return this.closed || this.isPinotDataFetched && this.dataTableList.isEmpty();
    }

    public Page getNextPage() {
        if (this.isFinished()) {
            this.close();
            return null;
        }
        if (!this.isPinotDataFetched) {
            this.fetchPinotData();
        }
        if (this.currentDataTable != null) {
            this.estimatedMemoryUsageInBytes -= (long)this.currentDataTable.getEstimatedSizeInBytes();
        }
        if (this.dataTableList.size() == 0) {
            this.close();
            return null;
        }
        this.currentDataTable = this.dataTableList.pop();
        PageBuilder pageBuilder = new PageBuilder(this.columnTypes);
        pageBuilder.declarePositions(this.currentDataTable.getDataTable().getNumberOfRows());
        for (int columnHandleIdx = 0; columnHandleIdx < this.columnHandles.size(); ++columnHandleIdx) {
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(columnHandleIdx);
            Type columnType = this.columnTypes.get(columnHandleIdx);
            this.writeBlock(blockBuilder, columnType, columnHandleIdx);
        }
        return pageBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchPinotData() {
        long startTimeNanos = System.nanoTime();
        try {
            Map<ServerInstance, DataTable> dataTableMap = this.queryPinot(this.session, this.split);
            dataTableMap.values().stream().filter(table -> table != null && table.getNumberOfRows() > 0).forEach(dataTable -> {
                PinotSegmentPageSource.checkExceptions(dataTable, this.split);
                int estimatedTableSizeInBytes = IntStream.rangeClosed(0, dataTable.getDataSchema().size() - 1).map(i -> this.getEstimatedColumnSizeInBytes(dataTable.getDataSchema().getColumnDataType(i)) * dataTable.getNumberOfRows()).reduce(0, Integer::sum);
                this.dataTableList.add(new PinotDataTableWithSize((DataTable)dataTable, estimatedTableSizeInBytes));
                this.estimatedMemoryUsageInBytes += (long)estimatedTableSizeInBytes;
            });
            this.columnTypes = this.columnHandles.stream().map(columnHandle -> this.getTypeForBlock((PinotColumnHandle)columnHandle)).collect(Collectors.toList());
            this.isPinotDataFetched = true;
        }
        finally {
            this.readTimeNanos += System.nanoTime() - startTimeNanos;
        }
    }

    private Map<ServerInstance, DataTable> queryPinot(ConnectorSession session, PinotSplit split) {
        String pql = split.getSegmentPql().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.empty(), "Expected the segment split to contain the pql"));
        String host = split.getSegmentHost().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.empty(), "Expected the segment split to contain the host"));
        try {
            return ImmutableMap.copyOf((Map)this.pinotQueryClient.queryPinotServerForDataTable(pql, host, split.getSegments(), PinotSessionProperties.getConnectionTimeout(session).toMillis(), PinotSessionProperties.isIgnoreEmptyResponses(session), PinotSessionProperties.getPinotRetryCount(session)));
        }
        catch (PinotScatterGatherQueryClient.PinotException pe) {
            throw new PinotException(PINOT_ERROR_CODE_MAP.getOrDefault(pe.getErrorCode(), PinotErrorCode.PINOT_UNCLASSIFIED_ERROR), Optional.of(pql), String.format("Error when hitting host %s", host), pe);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    private void writeBlock(BlockBuilder blockBuilder, Type columnType, int columnIdx) {
        Class javaType = columnType.getJavaType();
        DataSchema.ColumnDataType pinotColumnType = this.currentDataTable.getDataTable().getDataSchema().getColumnDataType(columnIdx);
        if (javaType.equals(Boolean.TYPE)) {
            this.writeBooleanBlock(blockBuilder, columnType, columnIdx);
        } else if (javaType.equals(Long.TYPE)) {
            this.writeLongBlock(blockBuilder, columnType, columnIdx);
        } else if (javaType.equals(Double.TYPE)) {
            this.writeDoubleBlock(blockBuilder, columnType, columnIdx);
        } else if (javaType.equals(Slice.class)) {
            this.writeSliceBlock(blockBuilder, columnType, columnIdx);
        } else {
            throw new PrestoException((ErrorCodeSupplier)PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, String.format("Failed to write column %s. pinotColumnType %s, javaType %s", this.columnHandles.get(columnIdx).getColumnName(), pinotColumnType, javaType));
        }
    }

    private void writeBooleanBlock(BlockBuilder blockBuilder, Type columnType, int columnIndex) {
        for (int i = 0; i < this.currentDataTable.getDataTable().getNumberOfRows(); ++i) {
            columnType.writeBoolean(blockBuilder, this.getBoolean(i, columnIndex));
            ++this.completedBytes;
        }
    }

    private void writeLongBlock(BlockBuilder blockBuilder, Type columnType, int columnIndex) {
        for (int i = 0; i < this.currentDataTable.getDataTable().getNumberOfRows(); ++i) {
            columnType.writeLong(blockBuilder, this.getLong(i, columnIndex));
            this.completedBytes += 8L;
        }
    }

    private void writeDoubleBlock(BlockBuilder blockBuilder, Type columnType, int columnIndex) {
        for (int i = 0; i < this.currentDataTable.getDataTable().getNumberOfRows(); ++i) {
            columnType.writeDouble(blockBuilder, this.getDouble(i, columnIndex));
            this.completedBytes += 8L;
        }
    }

    private void writeSliceBlock(BlockBuilder blockBuilder, Type columnType, int columnIndex) {
        for (int i = 0; i < this.currentDataTable.getDataTable().getNumberOfRows(); ++i) {
            Slice slice = this.getSlice(i, columnIndex);
            columnType.writeSlice(blockBuilder, slice, 0, slice.length());
            this.completedBytes += (long)slice.getBytes().length;
        }
    }

    private Type getType(int columnIndex) {
        Preconditions.checkArgument((columnIndex < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(columnIndex).getDataType();
    }

    private boolean getBoolean(int rowIdx, int columnIndex) {
        return Boolean.getBoolean(this.currentDataTable.getDataTable().getString(rowIdx, columnIndex));
    }

    private long getLong(int rowIndex, int columnIndex) {
        DataSchema.ColumnDataType dataType = this.currentDataTable.getDataTable().getDataSchema().getColumnDataType(columnIndex);
        if (dataType.equals((Object)DataSchema.ColumnDataType.DOUBLE)) {
            return (long)this.currentDataTable.getDataTable().getDouble(rowIndex, columnIndex);
        }
        if (dataType.equals((Object)DataSchema.ColumnDataType.INT)) {
            return this.currentDataTable.getDataTable().getInt(rowIndex, columnIndex);
        }
        return this.currentDataTable.getDataTable().getLong(rowIndex, columnIndex);
    }

    private double getDouble(int rowIndex, int columnIndex) {
        DataSchema.ColumnDataType dataType = this.currentDataTable.getDataTable().getDataSchema().getColumnDataType(columnIndex);
        if (dataType.equals((Object)DataSchema.ColumnDataType.FLOAT)) {
            return this.currentDataTable.getDataTable().getFloat(rowIndex, columnIndex);
        }
        return this.currentDataTable.getDataTable().getDouble(rowIndex, columnIndex);
    }

    private Slice getSlice(int rowIndex, int columnIndex) {
        this.checkColumnType(columnIndex, (Type)VarcharType.VARCHAR);
        DataSchema.ColumnDataType columnType = this.currentDataTable.getDataTable().getDataSchema().getColumnDataType(columnIndex);
        switch (columnType) {
            case INT_ARRAY: {
                int[] intArray = this.currentDataTable.getDataTable().getIntArray(rowIndex, columnIndex);
                return Slices.utf8Slice((String)Arrays.toString(intArray));
            }
            case LONG_ARRAY: {
                long[] longArray = this.currentDataTable.getDataTable().getLongArray(rowIndex, columnIndex);
                return Slices.utf8Slice((String)Arrays.toString(longArray));
            }
            case FLOAT_ARRAY: {
                float[] floatArray = this.currentDataTable.getDataTable().getFloatArray(rowIndex, columnIndex);
                return Slices.utf8Slice((String)Arrays.toString(floatArray));
            }
            case DOUBLE_ARRAY: {
                double[] doubleArray = this.currentDataTable.getDataTable().getDoubleArray(rowIndex, columnIndex);
                return Slices.utf8Slice((String)Arrays.toString(doubleArray));
            }
            case STRING_ARRAY: {
                Object[] stringArray = this.currentDataTable.getDataTable().getStringArray(rowIndex, columnIndex);
                return Slices.utf8Slice((String)Arrays.toString(stringArray));
            }
            case STRING: {
                String field = this.currentDataTable.getDataTable().getString(rowIndex, columnIndex);
                if (field == null || field.isEmpty()) {
                    return Slices.EMPTY_SLICE;
                }
                return Slices.utf8Slice((String)field);
            }
        }
        return Slices.EMPTY_SLICE;
    }

    private int getEstimatedColumnSizeInBytes(DataSchema.ColumnDataType dataType) {
        if (dataType.isNumber()) {
            switch (dataType) {
                case LONG: {
                    return 8;
                }
                case FLOAT: {
                    return 4;
                }
                case DOUBLE: {
                    return 8;
                }
            }
            return 4;
        }
        return this.pinotConfig.getEstimatedSizeInBytesForNonNumericColumn();
    }

    private void checkColumnType(int columnIndex, Type expected) {
        Type actual = this.getType(columnIndex);
        Preconditions.checkArgument((boolean)actual.equals(expected), (String)"Expected column %s to be type %s but is %s", (Object)columnIndex, (Object)expected, (Object)actual);
    }

    private Type getTypeForBlock(PinotColumnHandle pinotColumnHandle) {
        if (pinotColumnHandle.getDataType().equals(IntegerType.INTEGER)) {
            return BigintType.BIGINT;
        }
        return pinotColumnHandle.getDataType();
    }

    public long getCompletedPositions() {
        return 0L;
    }

    private static class PinotDataTableWithSize {
        DataTable dataTable;
        int estimatedSizeInBytes;

        PinotDataTableWithSize(DataTable dataTable, int estimatedSizeInBytes) {
            this.dataTable = dataTable;
            this.estimatedSizeInBytes = estimatedSizeInBytes;
        }

        DataTable getDataTable() {
            return this.dataTable;
        }

        int getEstimatedSizeInBytes() {
            return this.estimatedSizeInBytes;
        }
    }
}

