/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import javax.inject.Inject;

public class PinotSessionProperties {
    private static final String CONNECTION_TIMEOUT = "connection_timeout";
    private static final String FORBID_BROKER_QUERIES = "forbid_broker_queries";
    private static final String IGNORE_EMPTY_RESPONSES = "ignore_empty_responses";
    private static final String RETRY_COUNT = "retry_count";
    private static final String USE_DATE_TRUNC = "use_date_trunc";
    private static final String NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES = "non_aggregate_limit_for_broker_queries";
    @VisibleForTesting
    public static final String FORBID_SEGMENT_QUERIES = "forbid_segment_queries";
    @VisibleForTesting
    public static final String NUM_SEGMENTS_PER_SPLIT = "num_segments_per_split";
    private final List<PropertyMetadata<?>> sessionProperties;

    public static int getNumSegmentsPerSplit(ConnectorSession session) {
        int segmentsPerSplit = (Integer)session.getProperty(NUM_SEGMENTS_PER_SPLIT, Integer.class);
        return segmentsPerSplit <= 0 ? Integer.MAX_VALUE : segmentsPerSplit;
    }

    public static boolean isForbidBrokerQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(FORBID_BROKER_QUERIES, Boolean.class);
    }

    public static boolean isForbidSegmentQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(FORBID_SEGMENT_QUERIES, Boolean.class);
    }

    public static Duration getConnectionTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(CONNECTION_TIMEOUT, Duration.class);
    }

    public static boolean isIgnoreEmptyResponses(ConnectorSession session) {
        return (Boolean)session.getProperty(IGNORE_EMPTY_RESPONSES, Boolean.class);
    }

    public static int getPinotRetryCount(ConnectorSession session) {
        return (Integer)session.getProperty(RETRY_COUNT, Integer.class);
    }

    public static boolean isUseDateTruncation(ConnectorSession session) {
        return (Boolean)session.getProperty(USE_DATE_TRUNC, Boolean.class);
    }

    public static int getNonAggregateLimitForBrokerQueries(ConnectorSession session) {
        return (Integer)session.getProperty(NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES, Integer.class);
    }

    @Inject
    public PinotSessionProperties(PinotConfig pinotConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)FORBID_BROKER_QUERIES, (String)"Forbid queries to the broker", (Boolean)pinotConfig.isForbidBrokerQueries(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)FORBID_SEGMENT_QUERIES, (String)"Forbid segment queries", (Boolean)pinotConfig.isForbidSegmentQueries(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)IGNORE_EMPTY_RESPONSES, (String)"Ignore empty or missing pinot server responses", (Boolean)pinotConfig.isIgnoreEmptyResponses(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)RETRY_COUNT, (String)"Retry count for retriable pinot data fetch calls", (Integer)pinotConfig.getFetchRetryCount(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES, (String)"Max limit for non aggregate queries to the pinot broker", (Integer)pinotConfig.getNonAggregateLimitForBrokerQueries(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)USE_DATE_TRUNC, (String)"Use the new UDF dateTrunc in pinot that is more presto compatible", (Boolean)pinotConfig.isUseDateTrunc(), (boolean)false), (Object)new PropertyMetadata(CONNECTION_TIMEOUT, "Connection Timeout to talk to Pinot servers", (Type)VarcharType.createUnboundedVarcharType(), Duration.class, (Object)pinotConfig.getConnectionTimeout(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), (Object)new PropertyMetadata(NUM_SEGMENTS_PER_SPLIT, "Number of segments of the same host per split", (Type)IntegerType.INTEGER, Integer.class, (Object)pinotConfig.getNumSegmentsPerSplit(), false, value -> {
            int ret = ((Number)value).intValue();
            Preconditions.checkArgument((ret > 0 ? 1 : 0) != 0, (Object)"Number of segments per split must be more than zero");
            return ret;
        }, object -> object));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }
}

