/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotConnection;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.PinotSplit;
import com.facebook.presto.pinot.PinotTableHandle;
import com.facebook.presto.pinot.PinotTableLayoutHandle;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.ErrorType;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;

public class PinotSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final PinotConnection pinotPrestoConnection;

    @Inject
    public PinotSplitManager(ConnectorId connectorId, PinotConnection pinotPrestoConnection) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.pinotPrestoConnection = Objects.requireNonNull(pinotPrestoConnection, "pinotPrestoConnection is null");
    }

    protected ConnectorSplitSource generateSplitForBrokerBasedScan(PinotQueryGenerator.GeneratedPql brokerPql) {
        return new FixedSplitSource(Collections.singletonList(PinotSplit.createBrokerSplit(this.connectorId, brokerPql)));
    }

    protected ConnectorSplitSource generateSplitsForSegmentBasedScan(PinotTableLayoutHandle pinotLayoutHandle, ConnectorSession session) {
        PinotTableHandle tableHandle = pinotLayoutHandle.getTable();
        String tableName = tableHandle.getTableName();
        Map<String, Map<String, List<String>>> routingTable = this.pinotPrestoConnection.getRoutingTable(tableName);
        ArrayList<ConnectorSplit> splits = new ArrayList<ConnectorSplit>();
        if (!routingTable.isEmpty()) {
            PinotQueryGenerator.GeneratedPql segmentPql = tableHandle.getPql().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Expected to find realtime and offline pql in " + tableHandle));
            PinotClusterInfoFetcher.TimeBoundary timeBoundary = this.pinotPrestoConnection.getTimeBoundary(tableName);
            String realtime = this.getSegmentPql(segmentPql, "_REALTIME", timeBoundary.getOnlineTimePredicate());
            String offline = this.getSegmentPql(segmentPql, "_OFFLINE", timeBoundary.getOfflineTimePredicate());
            this.generateSegmentSplits(splits, routingTable, tableName, "_REALTIME", session, realtime);
            this.generateSegmentSplits(splits, routingTable, tableName, "_OFFLINE", session, offline);
        }
        Collections.shuffle(splits);
        return new FixedSplitSource(splits);
    }

    private String getSegmentPql(PinotQueryGenerator.GeneratedPql basePql, String suffix, Optional<String> timePredicate) {
        String pql = basePql.getPql().replace("__TABLE_NAME_SUFFIX_TEMPLATE__", suffix);
        if (timePredicate.isPresent()) {
            String tp = timePredicate.get();
            pql = pql.replace("__TIME_BOUNDARY_FILTER_TEMPLATE__", basePql.isHaveFilter() ? tp : " WHERE " + tp);
        } else {
            pql = pql.replace("__TIME_BOUNDARY_FILTER_TEMPLATE__", "");
        }
        return pql;
    }

    protected void generateSegmentSplits(List<ConnectorSplit> splits, Map<String, Map<String, List<String>>> routingTable, String tableName, String tableNameSuffix, ConnectorSession session, String pql) {
        String finalTableName = tableName + tableNameSuffix;
        int segmentsPerSplitConfigured = PinotSessionProperties.getNumSegmentsPerSplit(session);
        for (String routingTableName : routingTable.keySet()) {
            if (!routingTableName.equalsIgnoreCase(finalTableName)) continue;
            Map<String, List<String>> hostToSegmentsMap = routingTable.get(routingTableName);
            hostToSegmentsMap.forEach((host, segments) -> {
                int numSegmentsInThisSplit = Math.min(segments.size(), segmentsPerSplitConfigured);
                Iterables.partition((Iterable)segments, (int)numSegmentsInThisSplit).forEach(segmentsForThisSplit -> splits.add(PinotSplit.createSegmentSplit(this.connectorId, pql, segmentsForThisSplit, host)));
            });
        }
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        PinotTableLayoutHandle pinotLayoutHandle = (PinotTableLayoutHandle)layout;
        PinotTableHandle pinotTableHandle = pinotLayoutHandle.getTable();
        Supplier<PrestoException> errorSupplier = () -> new QueryNotAdequatelyPushedDownException(QueryNotAdequatelyPushedDownErrorCode.PQL_NOT_PRESENT, pinotTableHandle, this.connectorId);
        if (!pinotTableHandle.getIsQueryShort().orElseThrow(errorSupplier).booleanValue()) {
            if (PinotSessionProperties.isForbidSegmentQueries(session)) {
                throw errorSupplier.get();
            }
            return this.generateSplitsForSegmentBasedScan(pinotLayoutHandle, session);
        }
        return this.generateSplitForBrokerBasedScan(pinotTableHandle.getPql().orElseThrow(errorSupplier));
    }

    public static class QueryNotAdequatelyPushedDownException
    extends PrestoException {
        private final String connectorId;
        private final ConnectorTableHandle connectorTableHandle;

        public QueryNotAdequatelyPushedDownException(QueryNotAdequatelyPushedDownErrorCode errorCode, ConnectorTableHandle connectorTableHandle, String connectorId) {
            super((ErrorCodeSupplier)Objects.requireNonNull(errorCode, "error code is null"), (String)null);
            this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
            this.connectorTableHandle = Objects.requireNonNull(connectorTableHandle, "connector table handle is null");
        }

        public String getMessage() {
            return super.getMessage() + String.format(" table: %s:%s", this.connectorId, this.connectorTableHandle);
        }
    }

    public static enum QueryNotAdequatelyPushedDownErrorCode implements ErrorCodeSupplier
    {
        PQL_NOT_PRESENT(1, ErrorType.USER_ERROR, "Query uses unsupported expressions that cannot be pushed into the storage engine. Please see https://XXX for more details");

        private final ErrorCode errorCode;

        private QueryNotAdequatelyPushedDownErrorCode(int code, ErrorType type, String guidance) {
            this.errorCode = new ErrorCode(code + 103088128, this.name() + ": " + guidance, type);
        }

        public ErrorCode toErrorCode() {
            return this.errorCode;
        }
    }
}

