/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotColumn;
import com.facebook.presto.pinot.PinotColumnMetadata;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PinotTable {
    private final String name;
    private final List<PinotColumn> columns;
    private final List<ColumnMetadata> columnsMetadata;

    @JsonCreator
    public PinotTable(@JsonProperty(value="name") String name, @JsonProperty(value="columns") List<PinotColumn> columns) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = Objects.requireNonNull(name, "name is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.columnsMetadata = columns.stream().map(c -> new PinotColumnMetadata(c.getName(), c.getType())).collect(Collectors.toList());
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<PinotColumn> getColumns() {
        return this.columns;
    }

    public List<ColumnMetadata> getColumnsMetadata() {
        return this.columnsMetadata;
    }
}

