/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public final class PinotTableHandle
implements ConnectorTableHandle {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final Optional<Boolean> isQueryShort;
    private final Optional<PinotQueryGenerator.GeneratedPql> pql;

    public PinotTableHandle(String connectorId, String schemaName, String tableName) {
        this(connectorId, schemaName, tableName, Optional.empty(), Optional.empty());
    }

    @JsonCreator
    public PinotTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="isQueryShort") Optional<Boolean> isQueryShort, @JsonProperty(value="pql") Optional<PinotQueryGenerator.GeneratedPql> pql) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.isQueryShort = Objects.requireNonNull(isQueryShort, "safe to execute is null");
        this.pql = Objects.requireNonNull(pql, "broker pql is null");
    }

    @JsonProperty
    public Optional<PinotQueryGenerator.GeneratedPql> getPql() {
        return this.pql;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Optional<Boolean> getIsQueryShort() {
        return this.isQueryShort;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinotTableHandle that = (PinotTableHandle)o;
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.isQueryShort, that.isQueryShort) && Objects.equals(this.pql, that.pql);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.schemaName, this.tableName, this.isQueryShort, this.pql);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("isQueryShort", this.isQueryShort).add("pql", this.pql).toString();
    }
}

