/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotException;
import com.google.common.base.Preconditions;
import java.util.function.Function;

public class PinotUtils {
    private PinotUtils() {
    }

    static boolean isValidPinotHttpResponseCode(int status) {
        return status >= 200 && status < 300;
    }

    public static <T> T doWithRetries(int retries, Function<Integer, T> caller) {
        PinotException firstError = null;
        Preconditions.checkState((retries > 0 ? 1 : 0) != 0, (String)"Invalid num of retries %d", (int)retries);
        for (int i = 0; i < retries; ++i) {
            try {
                return caller.apply(i);
            }
            catch (PinotException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (e.getPinotErrorCode().isRetriable()) continue;
                throw e;
            }
        }
        throw firstError;
    }
}

