/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.query;

import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotPushdownUtils;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.query.PinotExpression;
import com.facebook.presto.pinot.query.PinotProjectExpressionConverter;
import com.facebook.presto.pinot.query.PinotQueryGeneratorContext;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTimeZone;

public class PinotAggregationProjectConverter
extends PinotProjectExpressionConverter {
    private static final Map<String, String> PRESTO_TO_PINOT_OPERATORS = ImmutableMap.of((Object)"-", (Object)"SUB", (Object)"+", (Object)"ADD", (Object)"*", (Object)"MULT", (Object)"/", (Object)"DIV");
    private static final String FROM_UNIXTIME = "from_unixtime";
    private final FunctionMetadataManager functionMetadataManager;
    private final ConnectorSession session;

    public PinotAggregationProjectConverter(TypeManager typeManager, FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution, ConnectorSession session) {
        super(typeManager, standardFunctionResolution);
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @Override
    public PinotExpression visitCall(CallExpression call, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        Optional<PinotExpression> basicCallHandlingResult = this.basicCallHandling(call, context);
        if (basicCallHandlingResult.isPresent()) {
            return basicCallHandlingResult.get();
        }
        FunctionMetadata functionMetadata = this.functionMetadataManager.getFunctionMetadata(call.getFunctionHandle());
        Optional operatorTypeOptional = functionMetadata.getOperatorType();
        if (operatorTypeOptional.isPresent()) {
            OperatorType operatorType = (OperatorType)operatorTypeOptional.get();
            if (operatorType.isArithmeticOperator()) {
                return this.handleArithmeticExpression(call, operatorType, context);
            }
            if (operatorType.isComparisonOperator()) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Comparison operator not supported: " + call);
            }
        }
        return this.handleFunction(call, context);
    }

    @Override
    public PinotExpression visitConstant(ConstantExpression literal, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        return new PinotExpression(PinotPushdownUtils.getLiteralAsString(literal), PinotQueryGeneratorContext.Origin.LITERAL);
    }

    private PinotExpression handleDateTruncationViaDateTimeConvert(CallExpression function, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        String outputGranularity;
        String value;
        String inputFormat;
        String inputColumn;
        RowExpression timeInputParameter = (RowExpression)function.getArguments().get(1);
        CallExpression timeConversion = this.getExpressionAsFunction(timeInputParameter, timeInputParameter);
        switch (timeConversion.getDisplayName().toLowerCase(Locale.ENGLISH)) {
            case "from_unixtime": {
                inputColumn = ((PinotExpression)((RowExpression)timeConversion.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition();
                inputFormat = "'1:SECONDS:EPOCH'";
                break;
            }
            default: {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "not supported: " + timeConversion.getDisplayName());
            }
        }
        String outputFormat = "'1:MILLISECONDS:EPOCH'";
        RowExpression intervalParameter = (RowExpression)function.getArguments().get(0);
        if (!(intervalParameter instanceof ConstantExpression)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "interval unit in date_trunc is not supported: " + intervalParameter);
        }
        switch (value = PinotAggregationProjectConverter.getStringFromConstant(intervalParameter)) {
            case "second": {
                outputGranularity = "'1:SECONDS'";
                break;
            }
            case "minute": {
                outputGranularity = "'1:MINUTES'";
                break;
            }
            case "hour": {
                outputGranularity = "'1:HOURS'";
                break;
            }
            case "day": {
                outputGranularity = "'1:DAYS'";
                break;
            }
            case "week": {
                outputGranularity = "'1:WEEKS'";
                break;
            }
            case "month": {
                outputGranularity = "'1:MONTHS'";
                break;
            }
            case "quarter": {
                outputGranularity = "'1:QUARTERS'";
                break;
            }
            case "year": {
                outputGranularity = "'1:YEARS'";
                break;
            }
            default: {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "interval in date_trunc is not supported: " + value);
            }
        }
        return PinotExpression.derived("dateTimeConvert(" + inputColumn + ", " + inputFormat + ", " + outputFormat + ", " + outputGranularity + ")");
    }

    private PinotExpression handleDateTruncationViaDateTruncation(CallExpression function, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        String inputFormat;
        String inputTimeZone;
        String inputColumn;
        RowExpression timeInputParameter = (RowExpression)function.getArguments().get(1);
        CallExpression timeConversion = this.getExpressionAsFunction(timeInputParameter, timeInputParameter);
        switch (timeConversion.getDisplayName().toLowerCase(Locale.ENGLISH)) {
            case "from_unixtime": {
                inputColumn = ((PinotExpression)((RowExpression)timeConversion.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition();
                inputTimeZone = timeConversion.getArguments().size() > 1 ? PinotAggregationProjectConverter.getStringFromConstant((RowExpression)timeConversion.getArguments().get(1)) : DateTimeZone.UTC.getID();
                inputFormat = "seconds";
                break;
            }
            default: {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "not supported: " + timeConversion.getDisplayName());
            }
        }
        RowExpression intervalParameter = (RowExpression)function.getArguments().get(0);
        if (!(intervalParameter instanceof ConstantExpression)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "interval unit in date_trunc is not supported: " + intervalParameter);
        }
        return PinotExpression.derived("dateTrunc(" + inputColumn + "," + inputFormat + ", " + inputTimeZone + ", " + PinotAggregationProjectConverter.getStringFromConstant(intervalParameter) + ")");
    }

    private PinotExpression handleArithmeticExpression(CallExpression expression, OperatorType operatorType, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        List arguments = expression.getArguments();
        if (arguments.size() == 1) {
            String prefix = operatorType == OperatorType.NEGATION ? "-" : "";
            return PinotExpression.derived(prefix + ((PinotExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, context)).getDefinition());
        }
        if (arguments.size() == 2) {
            PinotExpression left = (PinotExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, context);
            PinotExpression right = (PinotExpression)((RowExpression)arguments.get(1)).accept((RowExpressionVisitor)this, context);
            String prestoOperator = operatorType.getOperator();
            String pinotOperator = PRESTO_TO_PINOT_OPERATORS.get(prestoOperator);
            if (pinotOperator == null) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Unsupported binary expression " + prestoOperator);
            }
            return PinotExpression.derived(String.format("%s(%s, %s)", pinotOperator, left.getDefinition(), right.getDefinition()));
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Don't know how to interpret %s as an arithmetic expression", expression));
    }

    private PinotExpression handleFunction(CallExpression function, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        switch (function.getDisplayName().toLowerCase(Locale.ENGLISH)) {
            case "date_trunc": {
                boolean useDateTruncation = PinotSessionProperties.isUseDateTruncation(this.session);
                return useDateTruncation ? this.handleDateTruncationViaDateTruncation(function, context) : this.handleDateTruncationViaDateTimeConvert(function, context);
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("function %s not supported yet", function.getDisplayName()));
    }

    private static String getStringFromConstant(RowExpression expression) {
        if (expression instanceof ConstantExpression) {
            Object value = ((ConstantExpression)expression).getValue();
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Slice) {
                return ((Slice)value).toStringUtf8();
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Expected string literal but found " + expression);
    }

    private CallExpression getExpressionAsFunction(RowExpression originalExpression, RowExpression expression) {
        if (expression instanceof CallExpression) {
            CallExpression call = (CallExpression)expression;
            if (this.standardFunctionResolution.isCastFunction(call.getFunctionHandle())) {
                if (this.isImplicitCast(((RowExpression)call.getArguments().get(0)).getType(), call.getType())) {
                    return this.getExpressionAsFunction(originalExpression, (RowExpression)call.getArguments().get(0));
                }
            } else {
                return call;
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Could not dig function out of expression: " + originalExpression + ", inside of " + expression);
    }
}

