/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.query;

import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotPushdownUtils;
import com.facebook.presto.pinot.query.PinotExpression;
import com.facebook.presto.pinot.query.PinotQueryGeneratorContext;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PinotFilterExpressionConverter
implements RowExpressionVisitor<PinotExpression, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection>> {
    private static final Set<String> LOGICAL_BINARY_OPS_FILTER = ImmutableSet.of((Object)"=", (Object)"<", (Object)"<=", (Object)">", (Object)">=", (Object)"<>", (Object[])new String[0]);
    private final TypeManager typeManager;
    private final FunctionMetadataManager functionMetadataManager;
    private final StandardFunctionResolution standardFunctionResolution;

    public PinotFilterExpressionConverter(TypeManager typeManager, FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution) {
        this.typeManager = Objects.requireNonNull(typeManager, "type manager is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "function metadata manager is null");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standardFunctionResolution is null");
    }

    private PinotExpression handleIn(SpecialFormExpression specialForm, boolean isWhitelist, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        return PinotExpression.derived(String.format("(%s %s (%s))", ((PinotExpression)((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), isWhitelist ? "IN" : "NOT IN", specialForm.getArguments().subList(1, specialForm.getArguments().size()).stream().map(argument -> ((PinotExpression)argument.accept((RowExpressionVisitor)this, (Object)context)).getDefinition()).collect(Collectors.joining(", "))));
    }

    private PinotExpression handleLogicalBinary(String operator, CallExpression call, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (!LOGICAL_BINARY_OPS_FILTER.contains(operator)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("'%s' is not supported in filter", operator));
        }
        List arguments = call.getArguments();
        if (arguments.size() == 2) {
            return PinotExpression.derived(String.format("(%s %s %s)", ((PinotExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), operator, ((PinotExpression)((RowExpression)arguments.get(1)).accept((RowExpressionVisitor)this, context)).getDefinition()));
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Unknown logical binary: '%s'", call));
    }

    private PinotExpression handleBetween(CallExpression between, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (between.getArguments().size() == 3) {
            RowExpression value = (RowExpression)between.getArguments().get(0);
            RowExpression min = (RowExpression)between.getArguments().get(1);
            RowExpression max = (RowExpression)between.getArguments().get(2);
            return PinotExpression.derived(String.format("(%s BETWEEN %s AND %s)", ((PinotExpression)value.accept((RowExpressionVisitor)this, context)).getDefinition(), ((PinotExpression)min.accept((RowExpressionVisitor)this, context)).getDefinition(), ((PinotExpression)max.accept((RowExpressionVisitor)this, context)).getDefinition()));
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Between operator not supported: %s", between));
    }

    private PinotExpression handleNot(CallExpression not, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        SpecialFormExpression specialFormExpression;
        RowExpression input;
        if (not.getArguments().size() == 1 && (input = (RowExpression)not.getArguments().get(0)) instanceof SpecialFormExpression && (specialFormExpression = (SpecialFormExpression)input).getForm() == SpecialFormExpression.Form.IN) {
            return this.handleIn(specialFormExpression, false, context);
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("NOT operator is supported only on top of IN operator. Received: %s", not));
    }

    private PinotExpression handleCast(CallExpression cast, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (cast.getArguments().size() == 1) {
            RowExpression input = (RowExpression)cast.getArguments().get(0);
            Type expectedType = cast.getType();
            if (this.typeManager.canCoerce(input.getType(), expectedType)) {
                return (PinotExpression)input.accept((RowExpressionVisitor)this, context);
            }
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Non implicit casts not supported: " + cast);
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("This type of CAST operator not supported. Received: %s", cast));
    }

    public PinotExpression visitCall(CallExpression call, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        FunctionHandle functionHandle = call.getFunctionHandle();
        if (this.standardFunctionResolution.isNotFunction(functionHandle)) {
            return this.handleNot(call, context);
        }
        if (this.standardFunctionResolution.isCastFunction(functionHandle)) {
            return this.handleCast(call, context);
        }
        if (this.standardFunctionResolution.isBetweenFunction(functionHandle)) {
            return this.handleBetween(call, context);
        }
        FunctionMetadata functionMetadata = this.functionMetadataManager.getFunctionMetadata(call.getFunctionHandle());
        Optional operatorTypeOptional = functionMetadata.getOperatorType();
        if (operatorTypeOptional.isPresent()) {
            OperatorType operatorType = (OperatorType)operatorTypeOptional.get();
            if (operatorType.isArithmeticOperator()) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Arithmetic expressions are not supported in filter: " + call);
            }
            if (operatorType.isComparisonOperator()) {
                return this.handleLogicalBinary(operatorType.getOperator(), call, context);
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("function %s not supported in filter", call));
    }

    public PinotExpression visitInputReference(InputReferenceExpression reference, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Pinot does not support struct dereferencing " + reference);
    }

    public PinotExpression visitConstant(ConstantExpression literal, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        return new PinotExpression(PinotPushdownUtils.getLiteralAsString(literal), PinotQueryGeneratorContext.Origin.LITERAL);
    }

    public PinotExpression visitLambda(LambdaDefinitionExpression lambda, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Pinot does not support lambda " + lambda);
    }

    public PinotExpression visitVariableReference(VariableReferenceExpression reference, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        PinotQueryGeneratorContext.Selection input = Objects.requireNonNull(context.apply(reference), String.format("Input column %s does not exist in the input: %s", reference, context));
        return new PinotExpression(input.getDefinition(), input.getOrigin());
    }

    public PinotExpression visitSpecialForm(SpecialFormExpression specialForm, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        switch (specialForm.getForm()) {
            case IF: 
            case NULL_IF: 
            case SWITCH: 
            case WHEN: 
            case IS_NULL: 
            case COALESCE: 
            case DEREFERENCE: 
            case ROW_CONSTRUCTOR: 
            case BIND: {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Pinot does not support the special form " + specialForm);
            }
            case IN: {
                return this.handleIn(specialForm, true, context);
            }
            case AND: 
            case OR: {
                return PinotExpression.derived(String.format("(%s %s %s)", ((PinotExpression)((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), specialForm.getForm().toString(), ((PinotExpression)((RowExpression)specialForm.getArguments().get(1)).accept((RowExpressionVisitor)this, context)).getDefinition()));
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Unexpected special form: " + specialForm);
    }
}

