/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.query;

import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotPushdownUtils;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;

public class PinotQueryGeneratorContext {
    public static final String TIME_BOUNDARY_FILTER_TEMPLATE = "__TIME_BOUNDARY_FILTER_TEMPLATE__";
    public static final String TABLE_NAME_SUFFIX_TEMPLATE = "__TABLE_NAME_SUFFIX_TEMPLATE__";
    private final LinkedHashMap<VariableReferenceExpression, Selection> selections;
    private final LinkedHashSet<VariableReferenceExpression> groupByColumns;
    private final LinkedHashMap<VariableReferenceExpression, SortOrder> topNColumnOrderingMap;
    private final Set<VariableReferenceExpression> hiddenColumnSet;
    private final Set<VariableReferenceExpression> variablesInAggregation;
    private final Optional<String> from;
    private final Optional<String> filter;
    private final OptionalInt limit;
    private final int aggregations;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("selections", this.selections).add("groupByColumns", this.groupByColumns).add("topNColumnOrderingMap", this.topNColumnOrderingMap).add("hiddenColumnSet", this.hiddenColumnSet).add("variablesInAggregation", this.variablesInAggregation).add("from", this.from).add("filter", this.filter).add("limit", (Object)this.limit).add("aggregations", this.aggregations).toString();
    }

    PinotQueryGeneratorContext() {
        this(new LinkedHashMap<VariableReferenceExpression, Selection>(), null);
    }

    PinotQueryGeneratorContext(LinkedHashMap<VariableReferenceExpression, Selection> selections, String from) {
        this(selections, Optional.ofNullable(from), Optional.empty(), 0, new LinkedHashSet<VariableReferenceExpression>(), new LinkedHashMap<VariableReferenceExpression, SortOrder>(), OptionalInt.empty(), new HashSet<VariableReferenceExpression>(), new HashSet<VariableReferenceExpression>());
    }

    private PinotQueryGeneratorContext(LinkedHashMap<VariableReferenceExpression, Selection> selections, Optional<String> from, Optional<String> filter, int aggregations, LinkedHashSet<VariableReferenceExpression> groupByColumns, LinkedHashMap<VariableReferenceExpression, SortOrder> topNColumnOrderingMap, OptionalInt limit, Set<VariableReferenceExpression> variablesInAggregation, Set<VariableReferenceExpression> hiddenColumnSet) {
        this.selections = new LinkedHashMap(Objects.requireNonNull(selections, "selections can't be null"));
        this.from = Objects.requireNonNull(from, "source can't be null");
        this.aggregations = aggregations;
        this.groupByColumns = new LinkedHashSet(Objects.requireNonNull(groupByColumns, "groupByColumns can't be null. It could be empty if not available"));
        this.topNColumnOrderingMap = new LinkedHashMap(Objects.requireNonNull(topNColumnOrderingMap, "topNColumnOrderingMap can't be null. It could be empty if not available"));
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.hiddenColumnSet = Objects.requireNonNull(hiddenColumnSet, "hidden column set is null");
        this.variablesInAggregation = Objects.requireNonNull(variablesInAggregation, "variables in aggregation is null");
    }

    public PinotQueryGeneratorContext withFilter(String filter) {
        PinotPushdownUtils.checkSupported(!this.hasFilter(), "There already exists a filter. Pinot doesn't support filters at multiple levels", new Object[0]);
        PinotPushdownUtils.checkSupported(!this.hasAggregation(), "Pinot doesn't support filtering the results of aggregation", new Object[0]);
        PinotPushdownUtils.checkSupported(!this.hasLimit(), "Pinot doesn't support filtering on top of the limit", new Object[0]);
        return new PinotQueryGeneratorContext(this.selections, this.from, Optional.of(filter), this.aggregations, this.groupByColumns, this.topNColumnOrderingMap, this.limit, this.variablesInAggregation, this.hiddenColumnSet);
    }

    public PinotQueryGeneratorContext withAggregation(LinkedHashMap<VariableReferenceExpression, Selection> newSelections, LinkedHashSet<VariableReferenceExpression> groupByColumns, int aggregations, Set<VariableReferenceExpression> hiddenColumnSet) {
        PinotPushdownUtils.checkSupported(!this.hasAggregation(), "Pinot doesn't support aggregation on top of the aggregated data", new Object[0]);
        PinotPushdownUtils.checkSupported(!this.hasLimit(), "Pinot doesn't support aggregation on top of the limit", new Object[0]);
        PinotPushdownUtils.checkSupported(aggregations > 0, "Invalid number of aggregations", new Object[0]);
        return new PinotQueryGeneratorContext(newSelections, this.from, this.filter, aggregations, groupByColumns, this.topNColumnOrderingMap, this.limit, this.variablesInAggregation, hiddenColumnSet);
    }

    public PinotQueryGeneratorContext withProject(LinkedHashMap<VariableReferenceExpression, Selection> newSelections) {
        PinotPushdownUtils.checkSupported(this.groupByColumns.isEmpty(), "Pinot doesn't yet support new selections on top of the grouped by data", new Object[0]);
        return new PinotQueryGeneratorContext(newSelections, this.from, this.filter, this.aggregations, this.groupByColumns, this.topNColumnOrderingMap, this.limit, this.variablesInAggregation, this.hiddenColumnSet);
    }

    private static int checkForValidLimit(long limit) {
        if (limit <= 0L || limit > Integer.MAX_VALUE) {
            throw new PinotException(PinotErrorCode.PINOT_QUERY_GENERATOR_FAILURE, Optional.empty(), "Limit " + limit + " not supported: Limit is not being pushed down");
        }
        return StrictMath.toIntExact(limit);
    }

    public PinotQueryGeneratorContext withLimit(long limit) {
        int intLimit = PinotQueryGeneratorContext.checkForValidLimit(limit);
        PinotPushdownUtils.checkSupported(!this.hasLimit(), "Limit already exists. Pinot doesn't support limit on top of another limit", new Object[0]);
        return new PinotQueryGeneratorContext(this.selections, this.from, this.filter, this.aggregations, this.groupByColumns, this.topNColumnOrderingMap, OptionalInt.of(intLimit), this.variablesInAggregation, this.hiddenColumnSet);
    }

    public PinotQueryGeneratorContext withTopN(LinkedHashMap<VariableReferenceExpression, SortOrder> orderByColumnOrderingMap, long limit) {
        PinotPushdownUtils.checkSupported(!this.hasLimit(), "Limit already exists. Pinot doesn't support order by limit on top of another limit", new Object[0]);
        PinotPushdownUtils.checkSupported(!this.hasAggregation(), "Pinot doesn't support ordering on top of the aggregated data", new Object[0]);
        int intLimit = PinotQueryGeneratorContext.checkForValidLimit(limit);
        return new PinotQueryGeneratorContext(this.selections, this.from, this.filter, this.aggregations, this.groupByColumns, orderByColumnOrderingMap, OptionalInt.of(intLimit), this.variablesInAggregation, this.hiddenColumnSet);
    }

    private boolean hasFilter() {
        return this.filter.isPresent();
    }

    private boolean hasLimit() {
        return this.limit.isPresent();
    }

    private boolean hasAggregation() {
        return this.aggregations > 0;
    }

    private boolean hasOrderBy() {
        return !this.topNColumnOrderingMap.isEmpty();
    }

    public LinkedHashMap<VariableReferenceExpression, Selection> getSelections() {
        return this.selections;
    }

    public Set<VariableReferenceExpression> getHiddenColumnSet() {
        return this.hiddenColumnSet;
    }

    Set<VariableReferenceExpression> getVariablesInAggregation() {
        return this.variablesInAggregation;
    }

    public PinotQueryGenerator.GeneratedPql toQuery(PinotConfig pinotConfig, ConnectorSession session) {
        boolean forBroker;
        int nonAggregateShortQueryLimit = PinotSessionProperties.getNonAggregateLimitForBrokerQueries(session);
        boolean isQueryShort = this.hasAggregation() || this.limit.orElse(Integer.MAX_VALUE) < nonAggregateShortQueryLimit;
        boolean bl = forBroker = !PinotSessionProperties.isForbidBrokerQueries(session) && isQueryShort;
        if (!pinotConfig.isAllowMultipleAggregations() && this.aggregations > 1 && !this.groupByColumns.isEmpty()) {
            throw new PinotException(PinotErrorCode.PINOT_QUERY_GENERATOR_FAILURE, Optional.empty(), "Multiple aggregates in the presence of group by is forbidden");
        }
        if (this.hasLimit() && this.aggregations > 1 && !this.groupByColumns.isEmpty()) {
            throw new PinotException(PinotErrorCode.PINOT_QUERY_GENERATOR_FAILURE, Optional.empty(), "Multiple aggregates in the presence of group by and limit is forbidden");
        }
        String expressions = this.selections.entrySet().stream().filter(s -> !this.groupByColumns.contains(s.getKey())).map(s -> ((Selection)s.getValue()).getDefinition()).collect(Collectors.joining(", "));
        if (expressions.isEmpty()) {
            throw new PinotException(PinotErrorCode.PINOT_QUERY_GENERATOR_FAILURE, Optional.empty(), "Empty PQL expressions: " + this.toString());
        }
        String tableName = this.from.orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_QUERY_GENERATOR_FAILURE, Optional.empty(), "Table name not encountered yet"));
        String query = "SELECT " + expressions + " FROM " + tableName + (forBroker ? "" : TABLE_NAME_SUFFIX_TEMPLATE);
        if (this.filter.isPresent()) {
            String filterString = this.filter.get();
            query = query + String.format(" WHERE %s%s", filterString, forBroker ? "" : TIME_BOUNDARY_FILTER_TEMPLATE);
        } else if (!forBroker) {
            query = query + TIME_BOUNDARY_FILTER_TEMPLATE;
        }
        if (!this.groupByColumns.isEmpty()) {
            String groupByExpr = this.groupByColumns.stream().map(x -> this.selections.get(x).getDefinition()).collect(Collectors.joining(", "));
            query = query + " GROUP BY " + groupByExpr;
        }
        if (this.hasOrderBy()) {
            String orderByExpressions = this.topNColumnOrderingMap.entrySet().stream().map(entry -> this.selections.get(entry.getKey()).getDefinition() + (((SortOrder)entry.getValue()).isAscending() ? "" : " DESC")).collect(Collectors.joining(", "));
            query = query + " ORDER BY " + orderByExpressions;
        }
        String limitKeyWord = "";
        int queryLimit = -1;
        if (!this.hasAggregation()) {
            if (!this.limit.isPresent() && forBroker) {
                throw new PinotException(PinotErrorCode.PINOT_QUERY_GENERATOR_FAILURE, Optional.empty(), "Broker non aggregate queries have to have a limit");
            }
            queryLimit = this.limit.orElseGet(pinotConfig::getLimitLargeForSegment);
            limitKeyWord = "LIMIT";
        } else if (!this.groupByColumns.isEmpty()) {
            limitKeyWord = "TOP";
            if (this.limit.isPresent()) {
                if (this.aggregations > 1) {
                    throw new PinotException(PinotErrorCode.PINOT_QUERY_GENERATOR_FAILURE, Optional.of(query), "Pinot has weird semantics with group by and multiple aggregation functions and limits");
                }
                queryLimit = this.limit.getAsInt();
            } else {
                queryLimit = pinotConfig.getTopNLarge();
            }
        }
        if (!limitKeyWord.isEmpty()) {
            query = query + " " + limitKeyWord + " " + queryLimit;
        }
        List<Integer> indices = this.getIndicesMappingFromPinotSchemaToPrestoSchema(query, this.getAssignments());
        return new PinotQueryGenerator.GeneratedPql(tableName, query, indices, this.groupByColumns.size(), this.filter.isPresent(), isQueryShort);
    }

    private List<Integer> getIndicesMappingFromPinotSchemaToPrestoSchema(String query, Map<VariableReferenceExpression, PinotColumnHandle> assignments) {
        LinkedHashMap<VariableReferenceExpression, Selection> expressionsInPinotOrder = new LinkedHashMap<VariableReferenceExpression, Selection>();
        for (VariableReferenceExpression groupByColumn : this.groupByColumns) {
            Selection groupByColumnDefinition = this.selections.get(groupByColumn);
            if (groupByColumnDefinition == null) {
                throw new IllegalStateException(String.format("Group By column (%s) definition not found in input selections: %s", groupByColumn, Joiner.on((String)",").withKeyValueSeparator(":").join(this.selections)));
            }
            expressionsInPinotOrder.put(groupByColumn, groupByColumnDefinition);
        }
        expressionsInPinotOrder.putAll(this.selections);
        PinotPushdownUtils.checkSupported((long)assignments.size() == expressionsInPinotOrder.keySet().stream().filter(key -> !this.hiddenColumnSet.contains(key)).count(), "Expected returned expressions %s to match selections %s", Joiner.on((String)",").withKeyValueSeparator(":").join(expressionsInPinotOrder), Joiner.on((String)",").withKeyValueSeparator("=").join(assignments));
        HashMap<VariableReferenceExpression, Integer> assignmentToIndex = new HashMap<VariableReferenceExpression, Integer>();
        Iterator<Map.Entry<VariableReferenceExpression, PinotColumnHandle>> assignmentsIterator = assignments.entrySet().iterator();
        for (int i = 0; i < assignments.size(); ++i) {
            VariableReferenceExpression key2 = assignmentsIterator.next().getKey();
            Integer previous = assignmentToIndex.put(key2, i);
            if (previous == null) continue;
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.of(query), String.format("Expected Pinot column handle %s to occur only once, but we have: %s", key2, Joiner.on((String)",").withKeyValueSeparator("=").join(assignments)));
        }
        ImmutableList.Builder outputIndices = ImmutableList.builder();
        for (Map.Entry expression : expressionsInPinotOrder.entrySet()) {
            Integer index = this.hiddenColumnSet.contains(expression.getKey()) ? Integer.valueOf(-1) : (Integer)assignmentToIndex.get(expression.getKey());
            if (index == null) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.of(query), String.format("Expected to find a Pinot column handle for the expression %s, but we have %s", expression, Joiner.on((String)",").withKeyValueSeparator(":").join(assignmentToIndex)));
            }
            outputIndices.add((Object)index);
        }
        return outputIndices.build();
    }

    public LinkedHashMap<VariableReferenceExpression, PinotColumnHandle> getAssignments() {
        LinkedHashMap<VariableReferenceExpression, PinotColumnHandle> result = new LinkedHashMap<VariableReferenceExpression, PinotColumnHandle>();
        this.selections.entrySet().stream().filter(e -> !this.hiddenColumnSet.contains(e.getKey())).forEach(entry -> {
            VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
            Selection selection = (Selection)entry.getValue();
            PinotColumnHandle handle = selection.getOrigin() == Origin.TABLE_COLUMN ? new PinotColumnHandle(selection.getDefinition(), variable.getType(), PinotColumnHandle.PinotColumnType.REGULAR) : new PinotColumnHandle(variable, PinotColumnHandle.PinotColumnType.DERIVED);
            result.put(variable, handle);
        });
        return result;
    }

    public PinotQueryGeneratorContext withOutputColumns(List<VariableReferenceExpression> outputColumns) {
        LinkedHashMap<VariableReferenceExpression, Selection> newSelections = new LinkedHashMap<VariableReferenceExpression, Selection>();
        outputColumns.forEach(o -> newSelections.put((VariableReferenceExpression)o, Objects.requireNonNull(this.selections.get(o), String.format("Cannot find the selection %s in the original context %s", o, this))));
        this.selections.entrySet().stream().filter(e -> this.hiddenColumnSet.contains(e.getKey())).forEach(e -> {
            Selection cfr_ignored_0 = (Selection)newSelections.put((VariableReferenceExpression)e.getKey(), (Selection)e.getValue());
        });
        return new PinotQueryGeneratorContext(newSelections, this.from, this.filter, this.aggregations, this.groupByColumns, this.topNColumnOrderingMap, this.limit, this.variablesInAggregation, this.hiddenColumnSet);
    }

    public PinotQueryGeneratorContext withVariablesInAggregation(Set<VariableReferenceExpression> newVariablesInAggregation) {
        return new PinotQueryGeneratorContext(this.selections, this.from, this.filter, this.aggregations, this.groupByColumns, this.topNColumnOrderingMap, this.limit, newVariablesInAggregation, this.hiddenColumnSet);
    }

    public static class Selection {
        private final String definition;
        private final Origin origin;

        public Selection(String definition, Origin origin) {
            this.definition = definition;
            this.origin = origin;
        }

        public String getDefinition() {
            return this.definition;
        }

        public Origin getOrigin() {
            return this.origin;
        }

        public String toString() {
            return this.definition;
        }
    }

    public static enum Origin {
        TABLE_COLUMN,
        DERIVED,
        LITERAL;

    }
}

