/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.kudu.KuduConnector;
import com.facebook.presto.kudu.KuduHandleResolver;
import com.facebook.presto.kudu.KuduModule;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;

public class KuduConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "kudu";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new KuduHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new KuduModule(catalogName, context.getTypeManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(KuduConnector.class);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

