/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.kudu.KuduClientSession;
import com.facebook.presto.kudu.KuduColumnHandle;
import com.facebook.presto.kudu.KuduConnectorId;
import com.facebook.presto.kudu.KuduInsertTableHandle;
import com.facebook.presto.kudu.KuduOutputTableHandle;
import com.facebook.presto.kudu.KuduTableHandle;
import com.facebook.presto.kudu.KuduTableLayoutHandle;
import com.facebook.presto.kudu.TypeHelper;
import com.facebook.presto.kudu.properties.KuduTableProperties;
import com.facebook.presto.kudu.properties.PartitionDesign;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduTable;

public class KuduMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final KuduClientSession clientSession;

    @Inject
    public KuduMetadata(KuduConnectorId connectorId, KuduClientSession clientSession) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.clientSession.listSchemaNames();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.clientSession.listTables(schemaName);
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "SchemaTablePrefix is null");
        List tables = prefix.getTableName() == null ? this.listTables(session, prefix.getSchemaName()) : ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : tables) {
            KuduTableHandle tableHandle = this.getTableHandle(session, tableName);
            if (tableHandle == null) continue;
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableHandle);
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    private ColumnMetadata getColumnMetadata(ColumnSchema column) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        StringBuilder extra = new StringBuilder();
        if (column.isKey()) {
            properties.put("primary_key", true);
            extra.append("primary_key, ");
        }
        if (column.isNullable()) {
            properties.put("nullable", true);
            extra.append("nullable, ");
        }
        String encoding = KuduTableProperties.lookupEncodingString(column.getEncoding());
        if (!column.getEncoding().equals((Object)ColumnSchema.Encoding.AUTO_ENCODING)) {
            properties.put("encoding", encoding);
        }
        extra.append("encoding=").append(encoding).append(", ");
        String compression = KuduTableProperties.lookupCompressionString(column.getCompressionAlgorithm());
        if (!column.getCompressionAlgorithm().equals((Object)ColumnSchema.CompressionAlgorithm.DEFAULT_COMPRESSION)) {
            properties.put("compression", compression);
        }
        extra.append("compression=").append(compression);
        Type prestoType = TypeHelper.fromKuduColumn(column);
        return new ColumnMetadata(column.getName(), prestoType, null, extra.toString(), false, properties);
    }

    private ConnectorTableMetadata getTableMetadata(KuduTableHandle tableHandle) {
        KuduTable table = tableHandle.getTable(this.clientSession);
        Schema schema = table.getSchema();
        List columnsMetaList = (List)schema.getColumns().stream().filter(column -> !column.isKey() || !column.getName().equals("row_uuid")).map(this::getColumnMetadata).collect(ImmutableList.toImmutableList());
        Map<String, Object> properties = this.clientSession.getTableProperties(tableHandle);
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), columnsMetaList, properties);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle connectorTableHandle) {
        KuduTableHandle tableHandle = (KuduTableHandle)connectorTableHandle;
        Schema schema = this.clientSession.getTableSchema(tableHandle);
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (int ordinal = 0; ordinal < schema.getColumnCount(); ++ordinal) {
            ColumnSchema col = schema.getColumnByIndex(ordinal);
            String name = col.getName();
            Type type = TypeHelper.fromKuduColumn(col);
            KuduColumnHandle columnHandle = new KuduColumnHandle(name, ordinal, type);
            columnHandles.put((Object)name, (Object)columnHandle);
        }
        return columnHandles.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        KuduColumnHandle kuduColumnHandle = (KuduColumnHandle)columnHandle;
        if (kuduColumnHandle.isVirtualRowId()) {
            return new ColumnMetadata("row_uuid", (Type)VarbinaryType.VARBINARY, null, true);
        }
        return kuduColumnHandle.getColumnMetadata();
    }

    public KuduTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        try {
            KuduTable table = this.clientSession.openTable(schemaTableName);
            return new KuduTableHandle(this.connectorId, schemaTableName, table);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        KuduTableHandle handle = (KuduTableHandle)tableHandle;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new KuduTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary(), desiredColumns));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        return this.getTableMetadata(kuduTableHandle);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        this.clientSession.createSchema(schemaName);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        this.clientSession.dropSchema(schemaName);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.clientSession.createTable(tableMetadata, ignoreExisting);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        this.clientSession.dropTable(kuduTableHandle.getSchemaTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        this.clientSession.renameTable(kuduTableHandle.getSchemaTableName(), newTableName);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        this.clientSession.addColumn(kuduTableHandle.getSchemaTableName(), column);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        KuduColumnHandle kuduColumnHandle = (KuduColumnHandle)column;
        this.clientSession.dropColumn(kuduTableHandle.getSchemaTableName(), kuduColumnHandle.getName());
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        KuduColumnHandle kuduColumnHandle = (KuduColumnHandle)source;
        this.clientSession.renameColumn(kuduTableHandle.getSchemaTableName(), kuduColumnHandle.getName(), target);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle connectorTableHandle) {
        KuduTableHandle tableHandle = (KuduTableHandle)connectorTableHandle;
        KuduTable table = tableHandle.getTable(this.clientSession);
        Schema schema = table.getSchema();
        List columns = schema.getColumns();
        List columnTypes = (List)columns.stream().map(TypeHelper::fromKuduColumn).collect(ImmutableList.toImmutableList());
        return new KuduInsertTableHandle(this.connectorId, tableHandle.getSchemaTableName(), columnTypes, table);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        PartitionDesign design = KuduTableProperties.getPartitionDesign(tableMetadata.getProperties());
        boolean generateUUID = !design.hasPartitions();
        ConnectorTableMetadata finalTableMetadata = tableMetadata;
        if (generateUUID) {
            String rowId = "row_uuid";
            ArrayList<ColumnMetadata> copy = new ArrayList<ColumnMetadata>(tableMetadata.getColumns());
            HashMap<String, Boolean> columnProperties = new HashMap<String, Boolean>();
            columnProperties.put("primary_key", true);
            copy.add(0, new ColumnMetadata(rowId, (Type)VarcharType.VARCHAR, "key=true", null, true, columnProperties));
            ImmutableList finalColumns = ImmutableList.copyOf(copy);
            HashMap<String, Object> propsCopy = new HashMap<String, Object>(tableMetadata.getProperties());
            propsCopy.put("partition_by_hash_columns", ImmutableList.of((Object)rowId));
            propsCopy.put("partition_by_hash_buckets", 2);
            ImmutableMap finalProperties = ImmutableMap.copyOf(propsCopy);
            finalTableMetadata = new ConnectorTableMetadata(tableMetadata.getTable(), (List)finalColumns, (Map)finalProperties, tableMetadata.getComment());
        }
        KuduTable table = this.clientSession.createTable(finalTableMetadata, false);
        Schema schema = table.getSchema();
        List columns = schema.getColumns();
        List columnTypes = (List)columns.stream().map(TypeHelper::fromKuduColumn).collect(ImmutableList.toImmutableList());
        List columnOriginalTypes = (List)finalTableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        return new KuduOutputTableHandle(this.connectorId, finalTableMetadata.getTable(), columnOriginalTypes, columnTypes, generateUUID, table);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return KuduColumnHandle.ROW_ID_HANDLE;
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return tableHandle;
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
    }

    public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle) {
        return false;
    }
}

