/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.kudu.KuduClientSession;
import com.facebook.presto.kudu.KuduInsertTableHandle;
import com.facebook.presto.kudu.KuduOutputTableHandle;
import com.facebook.presto.kudu.KuduTableHandle;
import com.facebook.presto.kudu.KuduTableMapping;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlDecimal;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Upsert;

public class KuduPageSink
implements ConnectorPageSink {
    private final ConnectorSession connectorSession;
    private final KuduSession session;
    private final KuduTable table;
    private final List<Type> columnTypes;
    private final List<Type> originalColumnTypes;
    private final boolean generateUUID;
    private final String uuid;
    private int nextSubId;

    public KuduPageSink(ConnectorSession connectorSession, KuduClientSession clientSession, KuduInsertTableHandle tableHandle) {
        this(connectorSession, clientSession, tableHandle, tableHandle);
    }

    public KuduPageSink(ConnectorSession connectorSession, KuduClientSession clientSession, KuduOutputTableHandle tableHandle) {
        this(connectorSession, clientSession, tableHandle, tableHandle);
    }

    private KuduPageSink(ConnectorSession connectorSession, KuduClientSession clientSession, KuduTableHandle tableHandle, KuduTableMapping mapping) {
        Objects.requireNonNull(clientSession, "clientSession is null");
        this.connectorSession = connectorSession;
        this.columnTypes = mapping.getColumnTypes();
        this.originalColumnTypes = mapping.getOriginalColumnTypes();
        this.generateUUID = mapping.isGenerateUUID();
        this.table = tableHandle.getTable(clientSession);
        this.session = clientSession.newSession();
        this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        this.uuid = UUID.randomUUID().toString();
    }

    public CompletableFuture<?> appendPage(Page page) {
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Upsert upsert = this.table.newUpsert();
            PartialRow row = upsert.getRow();
            int start = 0;
            if (this.generateUUID) {
                String id = String.format("%s-%08x", this.uuid, this.nextSubId++);
                row.addString(0, id);
                start = 1;
            }
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                this.appendColumn(row, page, position, channel, channel + start);
            }
            try {
                this.session.apply((Operation)upsert);
                continue;
            }
            catch (KuduException e) {
                throw new RuntimeException(e);
            }
        }
        return NOT_BLOCKED;
    }

    private void appendColumn(PartialRow row, Page page, int position, int channel, int destChannel) {
        Block block = page.getBlock(channel);
        Type type = this.columnTypes.get(destChannel);
        if (block.isNull(position)) {
            row.setNull(destChannel);
        } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
            row.addLong(destChannel, type.getLong(block, position) * 1000L);
        } else if (RealType.REAL.equals((Object)type)) {
            row.addFloat(destChannel, Float.intBitsToFloat((int)type.getLong(block, position)));
        } else if (BigintType.BIGINT.equals((Object)type)) {
            row.addLong(destChannel, type.getLong(block, position));
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            row.addInt(destChannel, (int)type.getLong(block, position));
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            row.addShort(destChannel, (short)type.getLong(block, position));
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            row.addByte(destChannel, (byte)type.getLong(block, position));
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            row.addBoolean(destChannel, type.getBoolean(block, position));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            row.addDouble(destChannel, type.getDouble(block, position));
        } else if (Varchars.isVarcharType((Type)type)) {
            Type originalType = this.originalColumnTypes.get(destChannel);
            if (DateType.DATE.equals((Object)originalType)) {
                SqlDate date = (SqlDate)originalType.getObjectValue(this.connectorSession, block, position);
                LocalDateTime ldt = LocalDateTime.ofEpochSecond(TimeUnit.DAYS.toSeconds(date.getDays()), 0, ZoneOffset.UTC);
                byte[] bytes = ldt.format(DateTimeFormatter.ISO_LOCAL_DATE).getBytes(StandardCharsets.UTF_8);
                row.addStringUtf8(destChannel, bytes);
            } else {
                row.addString(destChannel, type.getSlice(block, position).toStringUtf8());
            }
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            row.addBinary(destChannel, type.getSlice(block, position).toByteBuffer());
        } else if (type instanceof DecimalType) {
            SqlDecimal sqlDecimal = (SqlDecimal)type.getObjectValue(this.connectorSession, block, position);
            row.addDecimal(destChannel, sqlDecimal.toBigDecimal());
        } else {
            throw new UnsupportedOperationException("Type is not supported: " + type);
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        this.closeSession();
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
        this.closeSession();
    }

    private void closeSession() {
        try {
            this.session.close();
        }
        catch (KuduException e) {
            throw new RuntimeException(e);
        }
    }
}

