/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.kudu.KuduRecordCursor;
import com.facebook.presto.kudu.RowHelper;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KeyEncoderAccessor;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;

public class KuduRecordCursorWithVirtualRowId
extends KuduRecordCursor {
    private final KuduTable table;
    private final Map<Integer, Integer> fieldMapping;

    public KuduRecordCursorWithVirtualRowId(KuduScanner scanner, KuduTable table, List<Type> columnTypes, Map<Integer, Integer> fieldMapping) {
        super(scanner, columnTypes);
        this.table = table;
        this.fieldMapping = fieldMapping;
    }

    @Override
    protected int mapping(int field) {
        return this.fieldMapping.get(field);
    }

    @Override
    public Slice getSlice(int field) {
        if (this.fieldMapping.get(field) == -1) {
            PartialRow partialRow = this.buildPrimaryKey();
            return Slices.wrappedBuffer((byte[])KeyEncoderAccessor.encodePrimaryKey(partialRow));
        }
        return super.getSlice(field);
    }

    private PartialRow buildPrimaryKey() {
        Schema schema = this.table.getSchema();
        PartialRow row = new PartialRow(schema);
        RowHelper.copyPrimaryKey(schema, this.currentRow, row);
        return row;
    }
}

