/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.kudu.KuduClientSession;
import com.facebook.presto.kudu.KuduColumnHandle;
import com.facebook.presto.kudu.KuduRecordCursor;
import com.facebook.presto.kudu.KuduRecordCursorWithVirtualRowId;
import com.facebook.presto.kudu.KuduSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;

public class KuduRecordSet
implements RecordSet {
    private final KuduClientSession clientSession;
    private final KuduSplit kuduSplit;
    private final List<? extends ColumnHandle> columns;
    private final boolean containsVirtualRowId;

    public KuduRecordSet(KuduClientSession clientSession, KuduSplit kuduSplit, List<? extends ColumnHandle> columns) {
        this.clientSession = clientSession;
        this.kuduSplit = kuduSplit;
        this.columns = columns;
        this.containsVirtualRowId = columns.contains(KuduColumnHandle.ROW_ID_HANDLE);
    }

    public List<Type> getColumnTypes() {
        return (List)this.columns.stream().map(column -> ((KuduColumnHandle)column).getType()).collect(ImmutableList.toImmutableList());
    }

    public RecordCursor cursor() {
        KuduScanner scanner = this.clientSession.createScanner(this.kuduSplit);
        if (!this.containsVirtualRowId) {
            return new KuduRecordCursor(scanner, this.getColumnTypes());
        }
        int primaryKeyColumnCount = this.kuduSplit.getPrimaryKeyColumnCount();
        HashMap<Integer, Integer> fieldMapping = new HashMap<Integer, Integer>();
        int index = primaryKeyColumnCount;
        for (int i = 0; i < this.columns.size(); ++i) {
            KuduColumnHandle handle = (KuduColumnHandle)this.columns.get(i);
            if (!handle.isVirtualRowId()) {
                if (handle.getOrdinalPosition() < primaryKeyColumnCount) {
                    fieldMapping.put(i, handle.getOrdinalPosition());
                    continue;
                }
                fieldMapping.put(i, index);
                ++index;
                continue;
            }
            fieldMapping.put(i, -1);
        }
        KuduTable table = this.getTable();
        return new KuduRecordCursorWithVirtualRowId(scanner, table, this.getColumnTypes(), fieldMapping);
    }

    KuduTable getTable() {
        return this.kuduSplit.getTableHandle().getTable(this.clientSession);
    }

    KuduClientSession getClientSession() {
        return this.clientSession;
    }
}

