/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.kudu.KuduClientSession;
import com.facebook.presto.kudu.KuduRecordSet;
import com.facebook.presto.kudu.RowHelper;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.block.Block;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.KeyEncoderAccessor;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.SessionConfiguration;

public class KuduUpdatablePageSource
implements UpdatablePageSource {
    private final KuduClientSession clientSession;
    private final KuduTable table;
    private final RecordPageSource inner;

    public KuduUpdatablePageSource(KuduRecordSet recordSet) {
        this.clientSession = recordSet.getClientSession();
        this.table = recordSet.getTable();
        this.inner = new RecordPageSource((RecordSet)recordSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRows(Block rowIds) {
        Schema schema = this.table.getSchema();
        KuduSession session = this.clientSession.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        try {
            try {
                for (int i = 0; i < rowIds.getPositionCount(); ++i) {
                    int len = rowIds.getSliceLength(i);
                    Slice slice = rowIds.getSlice(i, 0, len);
                    PartialRow row = KeyEncoderAccessor.decodePrimaryKey(schema, slice.getBytes());
                    Delete delete = this.table.newDelete();
                    RowHelper.copyPrimaryKey(schema, row, delete.getRow());
                    session.apply((Operation)delete);
                }
            }
            finally {
                session.close();
            }
        }
        catch (KuduException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        CompletableFuture<Collection<Slice>> cf = new CompletableFuture<Collection<Slice>>();
        cf.complete(Collections.emptyList());
        return cf;
    }

    public long getCompletedBytes() {
        return this.inner.getCompletedBytes();
    }

    public long getCompletedPositions() {
        return this.inner.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.inner.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.inner.isFinished();
    }

    public Page getNextPage() {
        return this.inner.getNextPage();
    }

    public long getSystemMemoryUsage() {
        return this.inner.getSystemMemoryUsage();
    }

    public void close() {
        this.inner.close();
    }
}

