/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Type;
import org.apache.kudu.client.RowResult;

public class TypeHelper {
    private TypeHelper() {
    }

    public static Type toKuduClientType(com.facebook.presto.spi.type.Type type) {
        if (type instanceof VarcharType) {
            return Type.STRING;
        }
        if (type == TimestampType.TIMESTAMP) {
            return Type.UNIXTIME_MICROS;
        }
        if (type == BigintType.BIGINT) {
            return Type.INT64;
        }
        if (type == IntegerType.INTEGER) {
            return Type.INT32;
        }
        if (type == SmallintType.SMALLINT) {
            return Type.INT16;
        }
        if (type == TinyintType.TINYINT) {
            return Type.INT8;
        }
        if (type == RealType.REAL) {
            return Type.FLOAT;
        }
        if (type == DoubleType.DOUBLE) {
            return Type.DOUBLE;
        }
        if (type == BooleanType.BOOLEAN) {
            return Type.BOOL;
        }
        if (type instanceof VarbinaryType) {
            return Type.BINARY;
        }
        if (type instanceof DecimalType) {
            return Type.DECIMAL;
        }
        if (type == DateType.DATE) {
            return Type.STRING;
        }
        if (type instanceof CharType) {
            return Type.STRING;
        }
        throw new IllegalStateException("Type mapping implemented for Presto type: " + type);
    }

    public static com.facebook.presto.spi.type.Type fromKuduColumn(ColumnSchema column) {
        return TypeHelper.fromKuduClientType(column.getType(), column.getTypeAttributes());
    }

    private static com.facebook.presto.spi.type.Type fromKuduClientType(Type ktype, ColumnTypeAttributes attributes) {
        switch (ktype) {
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case UNIXTIME_MICROS: {
                return TimestampType.TIMESTAMP;
            }
            case INT64: {
                return BigintType.BIGINT;
            }
            case INT32: {
                return IntegerType.INTEGER;
            }
            case INT16: {
                return SmallintType.SMALLINT;
            }
            case INT8: {
                return TinyintType.TINYINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case BOOL: {
                return BooleanType.BOOLEAN;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
            case DECIMAL: {
                return DecimalType.createDecimalType((int)attributes.getPrecision(), (int)attributes.getScale());
            }
        }
        throw new IllegalStateException("Kudu type not implemented for " + ktype);
    }

    public static Object getJavaValue(com.facebook.presto.spi.type.Type type, Object nativeValue) {
        if (type instanceof VarcharType) {
            return ((Slice)nativeValue).toStringUtf8();
        }
        if (type == TimestampType.TIMESTAMP) {
            return (Long)nativeValue * 1000L;
        }
        if (type == BigintType.BIGINT) {
            return nativeValue;
        }
        if (type == IntegerType.INTEGER) {
            return ((Long)nativeValue).intValue();
        }
        if (type == SmallintType.SMALLINT) {
            return ((Long)nativeValue).shortValue();
        }
        if (type == TinyintType.TINYINT) {
            return ((Long)nativeValue).byteValue();
        }
        if (type == DoubleType.DOUBLE) {
            return nativeValue;
        }
        if (type == RealType.REAL) {
            return Float.valueOf(Float.intBitsToFloat(((Long)nativeValue).intValue()));
        }
        if (type == BooleanType.BOOLEAN) {
            return nativeValue;
        }
        if (type instanceof VarbinaryType) {
            return ((Slice)nativeValue).toByteBuffer();
        }
        if (type instanceof DecimalType) {
            return nativeValue;
        }
        throw new IllegalStateException("Back conversion not implemented for " + type);
    }

    public static Object getObject(com.facebook.presto.spi.type.Type type, RowResult row, int field) {
        if (row.isNull(field)) {
            return null;
        }
        if (type instanceof VarcharType) {
            return row.getString(field);
        }
        if (type == TimestampType.TIMESTAMP) {
            return row.getLong(field) / 1000L;
        }
        if (type == BigintType.BIGINT) {
            return row.getLong(field);
        }
        if (type == IntegerType.INTEGER) {
            return row.getInt(field);
        }
        if (type == SmallintType.SMALLINT) {
            return row.getShort(field);
        }
        if (type == TinyintType.TINYINT) {
            return row.getByte(field);
        }
        if (type == DoubleType.DOUBLE) {
            return row.getDouble(field);
        }
        if (type == RealType.REAL) {
            return Float.valueOf(row.getFloat(field));
        }
        if (type == BooleanType.BOOLEAN) {
            return row.getBoolean(field);
        }
        if (type instanceof VarbinaryType) {
            return Slices.wrappedBuffer((ByteBuffer)row.getBinary(field));
        }
        if (type instanceof DecimalType) {
            return row.getDecimal(field);
        }
        throw new IllegalStateException("getObject not implemented for " + type);
    }

    public static long getLong(com.facebook.presto.spi.type.Type type, RowResult row, int field) {
        if (type == TimestampType.TIMESTAMP) {
            return row.getLong(field) / 1000L;
        }
        if (type == BigintType.BIGINT) {
            return row.getLong(field);
        }
        if (type == IntegerType.INTEGER) {
            return row.getInt(field);
        }
        if (type == SmallintType.SMALLINT) {
            return row.getShort(field);
        }
        if (type == TinyintType.TINYINT) {
            return row.getByte(field);
        }
        if (type == RealType.REAL) {
            return Float.floatToRawIntBits(row.getFloat(field));
        }
        if (type instanceof DecimalType) {
            DecimalType dtype = (DecimalType)type;
            if (dtype.isShort()) {
                return row.getDecimal(field).unscaledValue().longValue();
            }
            throw new IllegalStateException("getLong not supported for long decimal: " + type);
        }
        throw new IllegalStateException("getLong not implemented for " + type);
    }

    public static boolean getBoolean(com.facebook.presto.spi.type.Type type, RowResult row, int field) {
        if (type == BooleanType.BOOLEAN) {
            return row.getBoolean(field);
        }
        throw new IllegalStateException("getBoolean not implemented for " + type);
    }

    public static double getDouble(com.facebook.presto.spi.type.Type type, RowResult row, int field) {
        if (type == DoubleType.DOUBLE) {
            return row.getDouble(field);
        }
        throw new IllegalStateException("getDouble not implemented for " + type);
    }

    public static Slice getSlice(com.facebook.presto.spi.type.Type type, RowResult row, int field) {
        if (type instanceof VarcharType) {
            return Slices.utf8Slice((String)row.getString(field));
        }
        if (type instanceof VarbinaryType) {
            return Slices.wrappedBuffer((ByteBuffer)row.getBinary(field));
        }
        if (type instanceof DecimalType) {
            BigDecimal dec = row.getDecimal(field);
            return Decimals.encodeScaledValue((BigDecimal)dec);
        }
        throw new IllegalStateException("getSlice not implemented for " + type);
    }
}

