/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.DeadlineException;
import org.apache.hadoop.hive.metastore.api.MetaException;

public class Deadline {
    private static final Log LOG = LogFactory.getLog(Deadline.class.getName());
    private long timeout;
    private long startTime = -1L;
    private String method;
    private static final ThreadLocal<Deadline> DEADLINE_THREAD_LOCAL = new ThreadLocal<Deadline>(){

        @Override
        protected synchronized Deadline initialValue() {
            return null;
        }
    };

    private Deadline(long timeout) {
        this.timeout = timeout;
    }

    static void setCurrentDeadline(Deadline deadline) {
        DEADLINE_THREAD_LOCAL.set(deadline);
    }

    static Deadline getCurrentDeadline() {
        return DEADLINE_THREAD_LOCAL.get();
    }

    static void removeCurrentDeadline() {
        DEADLINE_THREAD_LOCAL.remove();
    }

    public static void registerIfNot(long timeout) {
        if (Deadline.getCurrentDeadline() == null) {
            Deadline.setCurrentDeadline(new Deadline(timeout));
        }
    }

    public static void resetTimeout(long timeout) throws MetaException {
        if (timeout <= 0L) {
            throw Deadline.newMetaException(new DeadlineException("The reset timeout value should be larger than 0: " + timeout));
        }
        Deadline deadline = Deadline.getCurrentDeadline();
        if (deadline == null) {
            throw Deadline.newMetaException(new DeadlineException("The threadlocal Deadline is null, please register it firstly."));
        }
        deadline.timeout = timeout;
    }

    public static boolean isStarted() throws MetaException {
        Deadline deadline = Deadline.getCurrentDeadline();
        if (deadline != null) {
            return deadline.startTime >= 0L;
        }
        throw Deadline.newMetaException(new DeadlineException("The threadlocal Deadline is null, please register it firstly."));
    }

    public static void startTimer(String method) throws MetaException {
        Deadline deadline = Deadline.getCurrentDeadline();
        if (deadline == null) {
            throw Deadline.newMetaException(new DeadlineException("The threadlocal Deadline is null, please register it firstly."));
        }
        deadline.startTime = System.currentTimeMillis();
        deadline.method = method;
    }

    public static void stopTimer() throws MetaException {
        Deadline deadline = Deadline.getCurrentDeadline();
        if (deadline == null) {
            throw Deadline.newMetaException(new DeadlineException("The threadlocal Deadline is null, please register it firstly."));
        }
        deadline.startTime = -1L;
        deadline.method = null;
    }

    public static void clear() {
        Deadline.removeCurrentDeadline();
    }

    public static void checkTimeout() throws MetaException {
        Deadline deadline = Deadline.getCurrentDeadline();
        if (deadline == null) {
            throw Deadline.newMetaException(new DeadlineException("The threadlocal Deadline is null, please register it first."));
        }
        deadline.check();
    }

    private void check() throws MetaException {
        try {
            if (this.startTime < 0L) {
                throw new DeadlineException("Should execute startTimer() method before checkTimeout. Error happens in method: " + this.method);
            }
            if (this.startTime + this.timeout < System.currentTimeMillis()) {
                throw new DeadlineException("Timeout when executing method: " + this.method);
            }
        }
        catch (DeadlineException e) {
            throw Deadline.newMetaException(e);
        }
    }

    private static MetaException newMetaException(DeadlineException e) {
        MetaException metaException = new MetaException(e.getMessage());
        metaException.initCause(e);
        return metaException;
    }
}

