/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractMapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.FlatRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;

public class HashMapWrapper
extends AbstractMapJoinTableContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log LOG = LogFactory.getLog(HashMapWrapper.class);
    private static final int THRESHOLD = 1000000;
    private static final float LOADFACTOR = 0.75f;
    private final HashMap<MapJoinKey, MapJoinRowContainer> mHash;
    private MapJoinKey lastKey = null;
    private ByteStream.Output output = new ByteStream.Output(0);

    public HashMapWrapper(Map<String, String> metaData) {
        super(metaData);
        int threshold = Integer.parseInt(metaData.get("threshold"));
        float loadFactor = Float.parseFloat(metaData.get("load"));
        this.mHash = new HashMap(threshold, loadFactor);
    }

    public HashMapWrapper() {
        this(HiveConf.ConfVars.HIVEHASHTABLEKEYCOUNTADJUSTMENT.defaultFloatVal, HiveConf.ConfVars.HIVEHASHTABLETHRESHOLD.defaultIntVal, HiveConf.ConfVars.HIVEHASHTABLELOADFACTOR.defaultFloatVal, -1L);
    }

    public HashMapWrapper(Configuration hconf, long keyCount) {
        this(HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLEKEYCOUNTADJUSTMENT), HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLETHRESHOLD), HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLELOADFACTOR), keyCount);
    }

    private HashMapWrapper(float keyCountAdj, int threshold, float loadFactor, long keyCount) {
        super(HashMapWrapper.createConstructorMetaData(threshold, loadFactor));
        threshold = HashMapWrapper.calculateTableSize(keyCountAdj, threshold, loadFactor, keyCount);
        this.mHash = new HashMap(threshold, loadFactor);
    }

    public static int calculateTableSize(float keyCountAdj, int threshold, float loadFactor, long keyCount) {
        if (keyCount >= 0L && keyCountAdj != 0.0f) {
            threshold = (int)Math.ceil((float)keyCount / (keyCountAdj * loadFactor));
        }
        LOG.info("Key count from statistics is " + keyCount + "; setting map size to " + threshold);
        return threshold;
    }

    @Override
    public MapJoinRowContainer get(MapJoinKey key) {
        return this.mHash.get(key);
    }

    @Override
    public void put(MapJoinKey key, MapJoinRowContainer value) {
        this.mHash.put(key, value);
    }

    @Override
    public int size() {
        return this.mHash.size();
    }

    @Override
    public Set<Map.Entry<MapJoinKey, MapJoinRowContainer>> entrySet() {
        return this.mHash.entrySet();
    }

    @Override
    public void clear() {
        this.mHash.clear();
    }

    @Override
    public MapJoinKey putRow(MapJoinObjectSerDeContext keyContext, Writable currentKey, MapJoinObjectSerDeContext valueContext, Writable currentValue) throws SerDeException, HiveException {
        MapJoinKey key = MapJoinKey.read(this.output, keyContext, currentKey);
        FlatRowContainer values = (FlatRowContainer)this.get(key);
        if (values == null) {
            values = new FlatRowContainer();
            this.put(key, values);
        }
        values.add(valueContext, (BytesWritable)currentValue);
        return key;
    }

    @Override
    public MapJoinTableContainer.ReusableGetAdaptor createGetter(MapJoinKey keyTypeFromLoader) {
        return new GetAdaptor(keyTypeFromLoader);
    }

    @Override
    public void seal() {
    }

    @Override
    public MapJoinKey getAnyKey() {
        return this.mHash.isEmpty() ? null : this.mHash.keySet().iterator().next();
    }

    @Override
    public void dumpMetrics() {
    }

    @Override
    public boolean hasSpill() {
        return false;
    }

    private class GetAdaptor
    implements MapJoinTableContainer.ReusableGetAdaptor {
        private Object[] currentKey;
        private List<ObjectInspector> vectorKeyOIs;
        private MapJoinKey key;
        private MapJoinRowContainer currentValue;
        private final ByteStream.Output output = new ByteStream.Output();
        private boolean isFirstKey = true;

        public GetAdaptor(MapJoinKey key) {
            this.key = key;
        }

        @Override
        public JoinUtil.JoinResult setFromVector(VectorHashKeyWrapper kw, VectorExpressionWriter[] keyOutputWriters, VectorHashKeyWrapperBatch keyWrapperBatch) throws HiveException {
            int i;
            if (this.currentKey == null) {
                this.currentKey = new Object[keyOutputWriters.length];
                this.vectorKeyOIs = new ArrayList<ObjectInspector>();
                for (i = 0; i < keyOutputWriters.length; ++i) {
                    this.vectorKeyOIs.add(keyOutputWriters[i].getObjectInspector());
                }
            }
            for (i = 0; i < keyOutputWriters.length; ++i) {
                this.currentKey[i] = keyWrapperBatch.getWritableKeyValue(kw, i, keyOutputWriters[i]);
            }
            this.key = MapJoinKey.readFromVector(this.output, this.key, this.currentKey, this.vectorKeyOIs, !this.isFirstKey);
            this.isFirstKey = false;
            this.currentValue = (MapJoinRowContainer)HashMapWrapper.this.mHash.get(this.key);
            if (this.currentValue == null) {
                return JoinUtil.JoinResult.NOMATCH;
            }
            return JoinUtil.JoinResult.MATCH;
        }

        @Override
        public JoinUtil.JoinResult setFromRow(Object row, List<ExprNodeEvaluator> fields, List<ObjectInspector> ois) throws HiveException {
            if (this.currentKey == null) {
                this.currentKey = new Object[fields.size()];
            }
            for (int keyIndex = 0; keyIndex < fields.size(); ++keyIndex) {
                this.currentKey[keyIndex] = fields.get(keyIndex).evaluate(row);
            }
            this.key = MapJoinKey.readFromRow(this.output, this.key, this.currentKey, ois, !this.isFirstKey);
            this.isFirstKey = false;
            this.currentValue = (MapJoinRowContainer)HashMapWrapper.this.mHash.get(this.key);
            if (this.currentValue == null) {
                return JoinUtil.JoinResult.NOMATCH;
            }
            return JoinUtil.JoinResult.MATCH;
        }

        @Override
        public JoinUtil.JoinResult setFromOther(MapJoinTableContainer.ReusableGetAdaptor other) {
            assert (other instanceof GetAdaptor);
            GetAdaptor other2 = (GetAdaptor)other;
            this.key = other2.key;
            this.isFirstKey = other2.isFirstKey;
            this.currentValue = (MapJoinRowContainer)HashMapWrapper.this.mHash.get(this.key);
            if (this.currentValue == null) {
                return JoinUtil.JoinResult.NOMATCH;
            }
            return JoinUtil.JoinResult.MATCH;
        }

        @Override
        public boolean hasAnyNulls(int fieldCount, boolean[] nullsafes) {
            return this.key.hasAnyNulls(fieldCount, nullsafes);
        }

        @Override
        public MapJoinRowContainer getCurrentRows() {
            return this.currentValue;
        }

        @Override
        public Object[] getCurrentKey() {
            return this.currentKey;
        }
    }
}

