/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableConf;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class HashTableLoader
implements org.apache.hadoop.hive.ql.exec.HashTableLoader {
    private static final Log LOG = LogFactory.getLog(HashTableLoader.class.getName());
    private Configuration hconf;
    private MapJoinDesc desc;
    private TezContext tezContext;

    @Override
    public void init(ExecMapperContext context, MapredContext mrContext, Configuration hconf, MapJoinOperator joinOp) {
        this.tezContext = (TezContext)mrContext;
        this.hconf = hconf;
        this.desc = (MapJoinDesc)joinOp.getConf();
    }

    @Override
    public void load(MapJoinTableContainer[] mapJoinTables, MapJoinTableContainerSerDe[] mapJoinTableSerdes) throws HiveException {
        long processMaxMemory;
        Map<Integer, String> parentToInput = this.desc.getParentToInput();
        Map<Integer, Long> parentKeyCounts = this.desc.getParentKeyCounts();
        boolean useOptimizedTables = HiveConf.getBoolVar(this.hconf, HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE);
        boolean useHybridGraceHashJoin = this.desc.isHybridHashJoin();
        boolean isFirstKey = true;
        long noConditionalTaskThreshold = HiveConf.getLongVar(this.hconf, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
        if (noConditionalTaskThreshold > (processMaxMemory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax())) {
            float hashtableMemoryUsage = HiveConf.getFloatVar(this.hconf, HiveConf.ConfVars.HIVEHASHTABLEFOLLOWBYGBYMAXMEMORYUSAGE);
            LOG.warn("noConditionalTaskThreshold value of " + noConditionalTaskThreshold + " is greater than the max memory size of " + processMaxMemory);
            noConditionalTaskThreshold = (long)((float)processMaxMemory * hashtableMemoryUsage);
        }
        HybridHashTableConf nwayConf = null;
        long totalSize = 0L;
        int biggest = 0;
        Map<Integer, Long> tableMemorySizes = null;
        if (useHybridGraceHashJoin && mapJoinTables.length > 2) {
            nwayConf = new HybridHashTableConf();
            long maxSize = Long.MIN_VALUE;
            for (int pos = 0; pos < mapJoinTables.length; ++pos) {
                if (pos == this.desc.getPosBigTable()) continue;
                long smallTableSize = this.desc.getParentDataSizes().get(pos);
                totalSize += smallTableSize;
                if (maxSize >= smallTableSize) continue;
                maxSize = smallTableSize;
                biggest = pos;
            }
            tableMemorySizes = HashTableLoader.divideHybridHashTableMemory(mapJoinTables, this.desc, totalSize, noConditionalTaskThreshold);
            long memory = tableMemorySizes.get(biggest);
            int numPartitions = 0;
            try {
                numPartitions = HybridHashTableContainer.calcNumPartitions(memory, maxSize, HiveConf.getIntVar(this.hconf, HiveConf.ConfVars.HIVEHYBRIDGRACEHASHJOINMINNUMPARTITIONS), HiveConf.getIntVar(this.hconf, HiveConf.ConfVars.HIVEHYBRIDGRACEHASHJOINMINWBSIZE), nwayConf);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            nwayConf.setNumberOfPartitions(numPartitions);
        }
        for (int pos = 0; pos < mapJoinTables.length; ++pos) {
            if (pos == this.desc.getPosBigTable()) continue;
            String inputName = parentToInput.get(pos);
            LogicalInput input = this.tezContext.getInput(inputName);
            try {
                input.start();
                this.tezContext.getTezProcessorContext().waitForAnyInputReady(Collections.singletonList(input));
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            try {
                ObjectInspector keyOi;
                KeyValueReader kvReader = (KeyValueReader)input.getReader();
                MapJoinObjectSerDeContext keyCtx = mapJoinTableSerdes[pos].getKeyContext();
                MapJoinObjectSerDeContext valCtx = mapJoinTableSerdes[pos].getValueContext();
                if (useOptimizedTables && !MapJoinBytesTableContainer.isSupportedKey(keyOi = keyCtx.getSerDe().getObjectInspector())) {
                    if (isFirstKey) {
                        useOptimizedTables = false;
                        LOG.info(this.describeOi("Not using optimized hash table. Only a subset of mapjoin keys is supported. Unsupported key: ", keyOi));
                    } else {
                        throw new HiveException(this.describeOi("Only a subset of mapjoin keys is supported. Unsupported key: ", keyOi));
                    }
                }
                isFirstKey = false;
                Long keyCountObj = parentKeyCounts.get(pos);
                long keyCount = keyCountObj == null ? -1L : keyCountObj;
                long memory = 0L;
                if (useHybridGraceHashJoin) {
                    memory = mapJoinTables.length > 2 ? tableMemorySizes.get(pos) : noConditionalTaskThreshold;
                }
                MapJoinTableContainer tableContainer = useOptimizedTables ? (useHybridGraceHashJoin ? new HybridHashTableContainer(this.hconf, keyCount, memory, this.desc.getParentDataSizes().get(pos), nwayConf) : new MapJoinBytesTableContainer(this.hconf, valCtx, keyCount, 0L)) : new HashMapWrapper(this.hconf, keyCount);
                LOG.info("Using tableContainer " + tableContainer.getClass().getSimpleName());
                while (kvReader.next()) {
                    tableContainer.putRow(keyCtx, (Writable)kvReader.getCurrentKey(), valCtx, (Writable)kvReader.getCurrentValue());
                }
                tableContainer.seal();
                mapJoinTables[pos] = tableContainer;
                continue;
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
    }

    private static Map<Integer, Long> divideHybridHashTableMemory(MapJoinTableContainer[] mapJoinTables, MapJoinDesc desc, long totalSize, long totalHashTableMemory) {
        boolean fallbackToEqualProportions;
        int smallTableCount = Math.max(mapJoinTables.length - 1, 1);
        HashMap<Integer, Long> tableMemorySizes = new HashMap<Integer, Long>();
        boolean bl = fallbackToEqualProportions = totalSize <= 0L;
        if (!fallbackToEqualProportions) {
            for (Map.Entry<Integer, Long> tableSizeEntry : desc.getParentDataSizes().entrySet()) {
                if (tableSizeEntry.getKey().intValue() == desc.getPosBigTable()) continue;
                long tableSize = tableSizeEntry.getValue();
                if (tableSize <= 0L) {
                    fallbackToEqualProportions = true;
                    break;
                }
                float percentage = (float)tableSize / (float)totalSize;
                long tableMemory = (long)((float)totalHashTableMemory * percentage);
                tableMemorySizes.put(tableSizeEntry.getKey(), tableMemory);
            }
        }
        if (fallbackToEqualProportions) {
            long equalPortion = totalHashTableMemory / (long)smallTableCount;
            for (Integer pos : desc.getParentDataSizes().keySet()) {
                if (pos.intValue() == desc.getPosBigTable()) break;
                tableMemorySizes.put(pos, equalPortion);
            }
        }
        return tableMemorySizes;
    }

    private String describeOi(String desc, ObjectInspector keyOi) {
        for (StructField structField : ((StructObjectInspector)keyOi).getAllStructFieldRefs()) {
            ObjectInspector oi = structField.getFieldObjectInspector();
            String cat = oi.getCategory().toString();
            if (oi.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                cat = ((PrimitiveObjectInspector)oi).getPrimitiveCategory().toString();
            }
            desc = desc + structField.getFieldName() + ":" + cat + ", ";
        }
        return desc;
    }
}

