/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class ConstantPropagateProcCtx
implements NodeProcessorCtx {
    private static final Log LOG = LogFactory.getLog(ConstantPropagateProcCtx.class);
    private final Map<Operator<? extends Serializable>, Map<ColumnInfo, ExprNodeDesc>> opToConstantExprs;
    private final List<Operator<? extends Serializable>> opToDelete;
    private ConstantPropagateOption constantPropagateOption = ConstantPropagateOption.FULL;

    public ConstantPropagateProcCtx() {
        this(ConstantPropagateOption.FULL);
    }

    public ConstantPropagateProcCtx(ConstantPropagateOption option) {
        this.opToConstantExprs = new HashMap<Operator<? extends Serializable>, Map<ColumnInfo, ExprNodeDesc>>();
        this.opToDelete = new ArrayList<Operator<? extends Serializable>>();
        this.constantPropagateOption = option;
    }

    public Map<Operator<? extends Serializable>, Map<ColumnInfo, ExprNodeDesc>> getOpToConstantExprs() {
        return this.opToConstantExprs;
    }

    private ColumnInfo resolve(ColumnInfo ci, RowSchema rs, RowSchema parentRS) {
        String tblAlias;
        ColumnInfo rci;
        String alias = ci.getAlias();
        if (alias == null) {
            alias = ci.getInternalName();
        }
        if ((rci = rs.getColumnInfo(tblAlias = ci.getTabAlias(), alias)) == null && rs.getTableNames().size() == 1 && parentRS.getTableNames().size() == 1) {
            rci = rs.getColumnInfo(rs.getTableNames().iterator().next(), alias);
        }
        if (rci == null) {
            return null;
        }
        LOG.debug("Resolved " + ci.getTabAlias() + "." + ci.getAlias() + " as " + rci.getTabAlias() + "." + rci.getAlias() + " with rs: " + rs);
        return rci;
    }

    public Map<ColumnInfo, ExprNodeDesc> getPropagatedConstants(Operator<? extends Serializable> op) {
        HashMap<ColumnInfo, ExprNodeDesc> constants = new HashMap<ColumnInfo, ExprNodeDesc>();
        if (op.getSchema() == null) {
            return constants;
        }
        RowSchema rs = op.getSchema();
        LOG.debug("Getting constants of op:" + op + " with rs:" + rs);
        if (op.getParentOperators() == null) {
            return constants;
        }
        if (op instanceof UnionOperator) {
            String alias = rs.getSignature().get(0).getTabAlias();
            HashMap<ColumnInfo, ExprNodeDesc> intersection = null;
            for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                Map<ColumnInfo, ExprNodeDesc> unionConst = this.opToConstantExprs.get(parent);
                LOG.debug("Constant of op " + parent.getOperatorId() + " " + unionConst);
                if (intersection == null) {
                    intersection = new HashMap<ColumnInfo, ExprNodeDesc>();
                    for (Map.Entry<ColumnInfo, ExprNodeDesc> entry : unionConst.entrySet()) {
                        ColumnInfo ci = new ColumnInfo(entry.getKey());
                        ci.setTabAlias(alias);
                        intersection.put(ci, entry.getValue());
                    }
                } else {
                    Iterator itr = intersection.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        boolean found = false;
                        for (Map.Entry<ColumnInfo, ExprNodeDesc> f : this.opToConstantExprs.get(parent).entrySet()) {
                            if (!((ColumnInfo)entry.getKey()).getInternalName().equals(f.getKey().getInternalName())) continue;
                            if (!((ExprNodeDesc)entry.getValue()).isSame(f.getValue())) break;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        itr.remove();
                    }
                }
                if (!intersection.isEmpty()) continue;
                return intersection;
            }
            LOG.debug("Propagated union constants:" + intersection);
            return intersection;
        }
        for (Operator<OperatorDesc> parent : op.getParentOperators()) {
            Map<ColumnInfo, ExprNodeDesc> c = this.opToConstantExprs.get(parent);
            for (Map.Entry<ColumnInfo, ExprNodeDesc> e : c.entrySet()) {
                ColumnInfo ci = e.getKey();
                Object var10_20 = null;
                ExprNodeDesc constant = e.getValue();
                ColumnInfo columnInfo = this.resolve(ci, rs, parent.getSchema());
                if (columnInfo != null) {
                    constants.put(columnInfo, constant);
                    continue;
                }
                LOG.debug("Can't resolve " + ci.getTabAlias() + "." + ci.getAlias() + "(" + ci.getInternalName() + ") from rs:" + rs);
            }
        }
        LOG.debug("Offerring constants " + constants.keySet() + " to operator " + op.toString());
        return constants;
    }

    public void addOpToDelete(Operator<? extends Serializable> op) {
        this.opToDelete.add(op);
    }

    public List<Operator<? extends Serializable>> getOpToDelete() {
        return this.opToDelete;
    }

    public ConstantPropagateOption getConstantPropagateOption() {
        return this.constantPropagateOption;
    }

    public void setConstantPropagateOption(ConstantPropagateOption constantPropagateOption) {
        this.constantPropagateOption = constantPropagateOption;
    }

    public static enum ConstantPropagateOption {
        FULL,
        SHORTCUT;

    }
}

