/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.Serializable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="char", value="CAST(<value> as CHAR(length)) - Converts the argument to a char value.", extended="Values will be truncated if the input value is too long to fit within the char length.Example:\n   > SELECT CAST(1234 AS char(10)) FROM src LIMIT 1;\n  '1234'")
public class GenericUDFToChar
extends GenericUDF
implements SettableUDF,
Serializable {
    private static final Log LOG = LogFactory.getLog(GenericUDFToChar.class.getName());
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.HiveCharConverter converter;
    private CharTypeInfo typeInfo;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentException("CHAR cast requires a value argument");
        }
        try {
            this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function CHAR takes only primitive types");
        }
        SettableHiveCharObjectInspector outputOI = (SettableHiveCharObjectInspector)((Object)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(this.typeInfo));
        this.converter = new PrimitiveObjectInspectorConverter.HiveCharConverter(this.argumentOI, outputOI);
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        return this.converter.convert(o0);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("CAST( ");
        sb.append(children[0]);
        sb.append(" AS CHAR(");
        sb.append("" + this.typeInfo.getLength());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void setTypeInfo(TypeInfo typeInfo) throws UDFArgumentException {
        this.typeInfo = (CharTypeInfo)typeInfo;
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }
}

