/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.pinot.PinotBrokerPageSourceBase;
import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorSession;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PinotBrokerPageSourcePql
extends PinotBrokerPageSourceBase {
    private static final String REQUEST_PAYLOAD_KEY = "pql";
    private static final String QUERY_URL_TEMPLATE_PLAIN = "http://%s/query";
    private static final String QUERY_URL_TEMPLATE_SECURE = "https://%s/query";
    private final PinotQueryGenerator.GeneratedPinotQuery brokerPql;
    private final List<PinotColumnHandle> expectedHandles;

    public PinotBrokerPageSourcePql(PinotConfig pinotConfig, ConnectorSession session, PinotQueryGenerator.GeneratedPinotQuery brokerPql, List<PinotColumnHandle> columnHandles, List<PinotColumnHandle> expectedHandles, PinotClusterInfoFetcher clusterInfoFetcher, ObjectMapper objectMapper) {
        super(pinotConfig, session, columnHandles, clusterInfoFetcher, objectMapper);
        this.expectedHandles = Objects.requireNonNull(expectedHandles, "expected handles is null");
        this.brokerPql = Objects.requireNonNull(brokerPql, "broker is null");
    }

    private void setValuesForGroupby(List<BlockBuilder> blockBuilders, List<Type> types, int numGroupByClause, JsonNode group, String[] values) {
        int i;
        Objects.requireNonNull(group, "Expected valid group");
        Objects.requireNonNull(values, "Expected valid values in group by");
        Preconditions.checkState((blockBuilders.size() == values.length + group.size() ? 1 : 0) != 0, (Object)String.format("Expected pinot to return total of %d values for group by, but got only %d group-by-keys and %d values", blockBuilders.size(), group.size(), values.length));
        for (i = 0; i < group.size(); ++i) {
            this.setValue(types.get(i), blockBuilders.get(i), group.get(i));
        }
        for (i = 0; i < values.length; ++i) {
            int metricColumnIndex = i + numGroupByClause;
            this.setValue(types.get(metricColumnIndex), blockBuilders.get(metricColumnIndex), values[i]);
        }
    }

    @Override
    protected PinotQueryGenerator.GeneratedPinotQuery getBrokerQuery() {
        return this.brokerPql;
    }

    @Override
    @VisibleForTesting
    public int populateFromQueryResults(PinotQueryGenerator.GeneratedPinotQuery pinotQuery, List<BlockBuilder> blockBuilders, List<Type> types, String responseJsonString) {
        int rowCount;
        JsonNode jsonBody;
        String pql = pinotQuery.getQuery();
        int numGroupByClause = pinotQuery.getGroupByClauses();
        try {
            jsonBody = this.objectMapper.readTree(responseJsonString);
        }
        catch (IOException e) {
            throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), "Couldn't parse response", e);
        }
        PinotBrokerPageSourcePql.handleCommonResponse(pql, jsonBody);
        JsonNode aggregationResults = jsonBody.get("aggregationResults");
        JsonNode selectionResults = jsonBody.get("selectionResults");
        if (aggregationResults != null && aggregationResults.isArray()) {
            Preconditions.checkState((aggregationResults.size() >= 1 ? 1 : 0) != 0, (Object)"Expected at least one metric to be present");
            HashMap<JsonNode, String[]> groupToValue = aggregationResults.size() == 1 || numGroupByClause == 0 ? null : new HashMap<JsonNode, String[]>();
            rowCount = 0;
            String[] singleAggregation = new String[1];
            Boolean seenGroupByResult = null;
            for (int aggregationIndex = 0; aggregationIndex < aggregationResults.size(); ++aggregationIndex) {
                JsonNode result = aggregationResults.get(aggregationIndex);
                JsonNode metricValuesForEachGroup = result.get("groupByResult");
                if (metricValuesForEachGroup != null) {
                    Preconditions.checkState((seenGroupByResult == null || seenGroupByResult != false ? 1 : 0) != 0);
                    seenGroupByResult = true;
                    Preconditions.checkState((numGroupByClause > 0 ? 1 : 0) != 0, (Object)"Expected having non zero group by clauses");
                    JsonNode groupByColumns = (JsonNode)Preconditions.checkNotNull((Object)result.get("groupByColumns"), (String)"groupByColumns missing in %s", (Object)pql);
                    if (groupByColumns.size() != numGroupByClause) {
                        throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), String.format("Expected %d gby columns but got %s instead from pinot", numGroupByClause, groupByColumns));
                    }
                    for (int groupByIndex = 0; groupByIndex < metricValuesForEachGroup.size(); ++groupByIndex) {
                        JsonNode row = metricValuesForEachGroup.get(groupByIndex);
                        JsonNode group2 = row.get("group");
                        if (group2 == null || !group2.isArray() || group2.size() != numGroupByClause) {
                            throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), String.format("Expected %d group by columns but got only a group of size %d (%s)", numGroupByClause, group2.size(), group2));
                        }
                        if (groupToValue == null) {
                            singleAggregation[0] = PinotBrokerPageSourcePql.asText(row.get("value"));
                            this.setValuesForGroupby(blockBuilders, types, numGroupByClause, group2, singleAggregation);
                            ++rowCount;
                            continue;
                        }
                        groupToValue.computeIfAbsent(group2, (Function<JsonNode, String[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$populateFromQueryResults$0(com.fasterxml.jackson.databind.JsonNode com.fasterxml.jackson.databind.JsonNode ), (Lcom/fasterxml/jackson/databind/JsonNode;)[Ljava/lang/String;)((JsonNode)aggregationResults))[aggregationIndex] = PinotBrokerPageSourcePql.asText(row.get("value"));
                    }
                    continue;
                }
                Preconditions.checkState((seenGroupByResult == null || seenGroupByResult == false ? 1 : 0) != 0);
                seenGroupByResult = false;
                Preconditions.checkState((numGroupByClause == 0 ? 1 : 0) != 0, (Object)"Expected no group by columns in pinot");
                this.setValue(types.get(aggregationIndex), blockBuilders.get(aggregationIndex), result.get("value"));
                rowCount = 1;
            }
            if (groupToValue != null) {
                Preconditions.checkState((rowCount == 0 ? 1 : 0) != 0, (Object)"Row count shouldn't have changed from zero");
                groupToValue.forEach((group, values) -> this.setValuesForGroupby(blockBuilders, types, numGroupByClause, (JsonNode)group, (String[])values));
                rowCount = groupToValue.size();
            }
        } else if (selectionResults != null) {
            JsonNode columns = selectionResults.get("columns");
            JsonNode results = selectionResults.get("results");
            if (columns == null || results == null || !columns.isArray() || !results.isArray() || columns.size() != blockBuilders.size()) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), String.format("Columns and results expected for %s, expected %d columns but got %d", pql, blockBuilders.size(), columns == null ? 0 : columns.size()));
            }
            this.setRows(pql, blockBuilders, types, results);
            rowCount = results.size();
        } else {
            throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(pql), "Expected one of aggregationResults or selectionResults to be present");
        }
        Preconditions.checkState((rowCount >= 0 ? 1 : 0) != 0, (Object)"Expected row count to be initialized");
        return rowCount;
    }

    @Override
    String getQueryUrlTemplate() {
        return this.pinotConfig.isUseSecureConnection() ? QUERY_URL_TEMPLATE_SECURE : QUERY_URL_TEMPLATE_PLAIN;
    }

    @Override
    String getRequestPayloadKey() {
        return REQUEST_PAYLOAD_KEY;
    }

    @Override
    @VisibleForTesting
    public PinotBrokerPageSourceBase.BlockAndTypeBuilder buildBlockAndTypeBuilder(List<PinotColumnHandle> columnHandles, PinotQueryGenerator.GeneratedPinotQuery brokerPql) {
        List expectedTypes = columnHandles.stream().map(PinotColumnHandle::getDataType).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(expectedTypes);
        Preconditions.checkState((brokerPql.getExpectedColumnIndices().size() >= this.expectedHandles.size() ? 1 : 0) != 0);
        Preconditions.checkState((this.expectedHandles.size() >= columnHandles.size() ? 1 : 0) != 0);
        int[] handleMapping = new int[this.expectedHandles.size()];
        for (int i = 0; i < handleMapping.length; ++i) {
            handleMapping[i] = columnHandles.indexOf(this.expectedHandles.get(i));
        }
        ArrayList<BlockBuilder> columnBlockBuilders = new ArrayList<BlockBuilder>();
        ArrayList<Type> columnTypes = new ArrayList<Type>();
        for (int expectedColumnIndex : brokerPql.getExpectedColumnIndices()) {
            int columnIndex = -1;
            if (expectedColumnIndex >= 0) {
                columnIndex = handleMapping[expectedColumnIndex];
            }
            columnBlockBuilders.add(columnIndex >= 0 ? pageBuilder.getBlockBuilder(columnIndex) : null);
            columnTypes.add(columnIndex >= 0 ? (Type)expectedTypes.get(columnIndex) : null);
        }
        return new PinotBrokerPageSourceBase.BlockAndTypeBuilder(pageBuilder, columnBlockBuilders, columnTypes);
    }

    private static /* synthetic */ String[] lambda$populateFromQueryResults$0(JsonNode aggregationResults, JsonNode ignored) {
        return new String[aggregationResults.size()];
    }
}

