/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.pinot.PinotBrokerPageSourceBase;
import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorSession;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class PinotBrokerPageSourceSql
extends PinotBrokerPageSourceBase {
    private static final String REQUEST_PAYLOAD_KEY = "sql";
    private static final String QUERY_URL_TEMPLATE_PLAIN = "http://%s/query/sql";
    private static final String QUERY_URL_TEMPLATE_SECURE = "https://%s/query/sql";
    private final PinotQueryGenerator.GeneratedPinotQuery brokerSql;
    private final List<PinotColumnHandle> expectedHandles;

    public PinotBrokerPageSourceSql(PinotConfig pinotConfig, ConnectorSession session, PinotQueryGenerator.GeneratedPinotQuery brokerSql, List<PinotColumnHandle> columnHandles, List<PinotColumnHandle> expectedHandles, PinotClusterInfoFetcher clusterInfoFetcher, ObjectMapper objectMapper) {
        super(pinotConfig, session, columnHandles, clusterInfoFetcher, objectMapper);
        this.expectedHandles = Objects.requireNonNull(expectedHandles, "expected handles is null");
        this.brokerSql = Objects.requireNonNull(brokerSql, "broker is null");
    }

    @Override
    protected PinotQueryGenerator.GeneratedPinotQuery getBrokerQuery() {
        return this.brokerSql;
    }

    @Override
    String getQueryUrlTemplate() {
        return this.pinotConfig.isUseSecureConnection() ? QUERY_URL_TEMPLATE_SECURE : QUERY_URL_TEMPLATE_PLAIN;
    }

    @Override
    String getRequestPayloadKey() {
        return REQUEST_PAYLOAD_KEY;
    }

    @Override
    @VisibleForTesting
    public int populateFromQueryResults(PinotQueryGenerator.GeneratedPinotQuery pinotQuery, List<BlockBuilder> blockBuilders, List<Type> types, String responseJsonString) {
        JsonNode jsonBody;
        String sql = pinotQuery.getQuery();
        try {
            jsonBody = this.objectMapper.readTree(responseJsonString);
        }
        catch (IOException e) {
            throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), "Couldn't parse response", e);
        }
        PinotBrokerPageSourceSql.handleCommonResponse(sql, jsonBody);
        JsonNode resultTable = jsonBody.get("resultTable");
        if (resultTable != null) {
            JsonNode dataSchema = resultTable.get("dataSchema");
            if (dataSchema == null) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), String.format("Expected data schema in the response", new Object[0]));
            }
            JsonNode columnDataTypes = dataSchema.get("columnDataTypes");
            JsonNode columnNames = dataSchema.get("columnNames");
            if (columnDataTypes == null || !columnDataTypes.isArray() || columnDataTypes.size() < blockBuilders.size()) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), String.format("ColumnDataTypes and results expected for %s, expected %d columnDataTypes but got %d", sql, blockBuilders.size(), columnDataTypes == null ? 0 : columnDataTypes.size()));
            }
            if (columnNames == null || !columnNames.isArray() || columnNames.size() < blockBuilders.size()) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), String.format("ColumnNames and results expected for %s, expected %d columnNames but got %d", sql, blockBuilders.size(), columnNames == null ? 0 : columnNames.size()));
            }
            JsonNode rows = resultTable.get("rows");
            this.setRows(sql, blockBuilders, types, rows);
            return rows.size();
        }
        return 0;
    }

    @Override
    @VisibleForTesting
    public PinotBrokerPageSourceBase.BlockAndTypeBuilder buildBlockAndTypeBuilder(List<PinotColumnHandle> columnHandles, PinotQueryGenerator.GeneratedPinotQuery brokerSql) {
        List expectedTypes = columnHandles.stream().map(PinotColumnHandle::getDataType).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(expectedTypes);
        int[] handleMapping = new int[this.expectedHandles.size()];
        for (int i = 0; i < handleMapping.length; ++i) {
            handleMapping[i] = columnHandles.indexOf(this.expectedHandles.get(i));
        }
        ArrayList<BlockBuilder> columnBlockBuilders = new ArrayList<BlockBuilder>();
        ArrayList<Type> columnTypes = new ArrayList<Type>();
        for (int expectedColumnIndex : brokerSql.getExpectedColumnIndices()) {
            int columnIndex = -1;
            if (expectedColumnIndex >= 0) {
                columnIndex = handleMapping[expectedColumnIndex];
            }
            columnBlockBuilders.add(columnIndex >= 0 ? pageBuilder.getBlockBuilder(columnIndex) : null);
            columnTypes.add(columnIndex >= 0 ? (Type)expectedTypes.get(columnIndex) : null);
        }
        return new PinotBrokerPageSourceBase.BlockAndTypeBuilder(pageBuilder, columnBlockBuilders, columnTypes);
    }
}

