/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.http.client.StringResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.pinot.ForPinot;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotMetrics;
import com.facebook.presto.pinot.PinotUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class PinotClusterInfoFetcher {
    private static final Logger log = Logger.get(PinotClusterInfoFetcher.class);
    private static final String HTTPS_SCHEME = "https";
    private static final String HTTP_SCHEME = "http";
    private static final String APPLICATION_JSON = "application/json";
    private static final Pattern BROKER_PATTERN = Pattern.compile("Broker_(.*)_(\\d+)");
    private static final String GET_ALL_TABLES_API_TEMPLATE = "tables";
    private static final String TABLE_INSTANCES_API_TEMPLATE = "tables/%s/instances";
    private static final String TABLE_SCHEMA_API_TEMPLATE = "tables/%s/schema";
    private static final String INSTANCE_API_TEMPLATE = "instances/%s";
    private static final String ROUTING_TABLE_API_TEMPLATE = "debug/routingTable/%s";
    private static final String TIME_BOUNDARY_API_TEMPLATE = "debug/timeBoundary/%s";
    private static final String TIME_BOUNDARY_NOT_FOUND_ERROR_CODE = "404";
    private final PinotConfig pinotConfig;
    private final PinotMetrics pinotMetrics;
    private final HttpClient httpClient;
    private final Ticker ticker = Ticker.systemTicker();
    private final LoadingCache<String, List<String>> brokersForTableCache;
    private final LoadingCache<String, Instance> instanceConfigCache;
    private final JsonCodec<GetTables> tablesJsonCodec;
    private final JsonCodec<BrokersForTable> brokersForTableJsonCodec;
    private final JsonCodec<RoutingTables> routingTablesJsonCodec;
    private final JsonCodec<RoutingTablesV2> routingTablesV2JsonCodec;
    private final JsonCodec<TimeBoundary> timeBoundaryJsonCodec;
    private final JsonCodec<Instance> instanceJsonCodec;

    @Inject
    public PinotClusterInfoFetcher(PinotConfig pinotConfig, PinotMetrics pinotMetrics, @ForPinot HttpClient httpClient, JsonCodec<GetTables> tablesJsonCodec, JsonCodec<BrokersForTable> brokersForTableJsonCodec, JsonCodec<RoutingTables> routingTablesJsonCodec, JsonCodec<RoutingTablesV2> routingTablesV2JsonCodec, JsonCodec<TimeBoundary> timeBoundaryJsonCodec, JsonCodec<Instance> instanceJsonCodec) {
        this.pinotConfig = Objects.requireNonNull(pinotConfig, "pinotConfig is null");
        this.pinotMetrics = Objects.requireNonNull(pinotMetrics, "pinotMetrics is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.tablesJsonCodec = Objects.requireNonNull(tablesJsonCodec, "json codec is null");
        this.brokersForTableJsonCodec = Objects.requireNonNull(brokersForTableJsonCodec, "brokers for table json codec is null");
        this.routingTablesJsonCodec = Objects.requireNonNull(routingTablesJsonCodec, "routing tables json codec is null");
        this.routingTablesV2JsonCodec = Objects.requireNonNull(routingTablesV2JsonCodec, "routing tables v2 json codec is null");
        this.timeBoundaryJsonCodec = Objects.requireNonNull(timeBoundaryJsonCodec, "time boundary json codec is null");
        this.instanceJsonCodec = Objects.requireNonNull(instanceJsonCodec, "instance json codec is null");
        long cacheExpiryMs = pinotConfig.getMetadataCacheExpiry().roundTo(TimeUnit.MILLISECONDS);
        this.brokersForTableCache = CacheBuilder.newBuilder().expireAfterWrite(cacheExpiryMs, TimeUnit.MILLISECONDS).build(CacheLoader.from(this::getAllBrokersForTable));
        this.instanceConfigCache = CacheBuilder.newBuilder().expireAfterWrite(cacheExpiryMs, TimeUnit.MILLISECONDS).build(CacheLoader.from(this::getInstance));
    }

    public static JsonCodecBinder addJsonBinders(JsonCodecBinder jsonCodecBinder) {
        jsonCodecBinder.bindJsonCodec(GetTables.class);
        jsonCodecBinder.bindJsonCodec(BrokersForTable.InstancesInBroker.class);
        jsonCodecBinder.bindJsonCodec(BrokersForTable.class);
        jsonCodecBinder.bindJsonCodec(RoutingTables.class);
        jsonCodecBinder.bindJsonCodec(RoutingTables.RoutingTableSnapshot.class);
        jsonCodecBinder.bindJsonCodec(RoutingTablesV2.class);
        jsonCodecBinder.bindJsonCodec(TimeBoundary.class);
        jsonCodecBinder.bindJsonCodec(Instance.class);
        return jsonCodecBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doHttpActionWithHeaders(Request.Builder requestBuilder, Optional<String> requestBody, Optional<String> rpcService) {
        long duration;
        StringResponseHandler.StringResponse response;
        requestBuilder = requestBuilder.setHeader("Accept", APPLICATION_JSON);
        if (requestBody.isPresent()) {
            requestBuilder.setHeader("Content-Type", APPLICATION_JSON);
        }
        if (rpcService.isPresent()) {
            requestBuilder.setHeader(this.pinotConfig.getCallerHeaderParam(), this.pinotConfig.getCallerHeaderValue()).setHeader(this.pinotConfig.getServiceHeaderParam(), rpcService.get());
        }
        if (requestBody.isPresent()) {
            requestBuilder.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)requestBody.get(), (Charset)StandardCharsets.UTF_8));
        }
        this.pinotConfig.getExtraHttpHeaders().forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).setHeader(arg_0, arg_1));
        Request request = requestBuilder.build();
        long startTime = this.ticker.read();
        try {
            response = (StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        }
        finally {
            duration = this.ticker.read() - startTime;
        }
        this.pinotMetrics.monitorRequest(request, response, duration, TimeUnit.NANOSECONDS);
        String responseBody = response.getBody();
        if (PinotUtils.isValidPinotHttpResponseCode(response.getStatusCode())) {
            return responseBody;
        }
        throw new PinotException(PinotErrorCode.PINOT_HTTP_ERROR, Optional.empty(), String.format("Unexpected response status: %d for request %s to url %s, with headers %s, full response %s", response.getStatusCode(), requestBody.orElse(""), request.getUri(), request.getHeaders(), responseBody));
    }

    private String sendHttpGetToController(String path) {
        URI controllerPathUri = HttpUriBuilder.uriBuilder().scheme(this.pinotConfig.isUseSecureConnection() ? HTTPS_SCHEME : HTTP_SCHEME).hostAndPort(HostAndPort.fromString((String)this.pinotConfig.getControllerUrl())).appendPath(path).build();
        Request.builder();
        return this.doHttpActionWithHeaders(Request.Builder.prepareGet().setUri(controllerPathUri), Optional.empty(), Optional.ofNullable(this.pinotConfig.getControllerRestService()));
    }

    private String sendHttpGetToBroker(String table, String path) {
        String hostPort = this.pinotConfig.isUseProxy() ? this.pinotConfig.getControllerUrl() : this.getBrokerHost(table);
        URI brokerPathUri = HttpUriBuilder.uriBuilder().scheme(this.pinotConfig.isUseSecureConnection() ? HTTPS_SCHEME : HTTP_SCHEME).hostAndPort(HostAndPort.fromString((String)hostPort)).appendPath(path).build();
        Request.builder();
        return this.doHttpActionWithHeaders(Request.Builder.prepareGet().setUri(brokerPathUri), Optional.empty(), Optional.empty());
    }

    public List<String> getAllTables() {
        return ((GetTables)this.tablesJsonCodec.fromJson(this.sendHttpGetToController(GET_ALL_TABLES_API_TEMPLATE))).getTables();
    }

    public Schema getTableSchema(String table) throws Exception {
        String responseBody = this.sendHttpGetToController(String.format(TABLE_SCHEMA_API_TEMPLATE, table));
        return Schema.fromString((String)responseBody);
    }

    @VisibleForTesting
    List<String> getAllBrokersForTable(String table) {
        String responseBody = this.sendHttpGetToController(String.format(TABLE_INSTANCES_API_TEMPLATE, table));
        ArrayList brokers = ((BrokersForTable)this.brokersForTableJsonCodec.fromJson(responseBody)).getBrokers().stream().flatMap(broker -> broker.getInstances().stream()).distinct().map(brokerToParse -> {
            Matcher matcher = BROKER_PATTERN.matcher((CharSequence)brokerToParse);
            if (matcher.matches() && matcher.groupCount() == 2) {
                return matcher.group(1) + ":" + matcher.group(2);
            }
            throw new PinotException(PinotErrorCode.PINOT_UNABLE_TO_FIND_BROKER, Optional.empty(), String.format("Cannot parse %s in the broker instance", brokerToParse));
        }).collect(Collectors.toCollection(() -> new ArrayList()));
        Collections.shuffle(brokers);
        return ImmutableList.copyOf((Collection)brokers);
    }

    public String getBrokerHost(String table) {
        try {
            List brokers = (List)this.brokersForTableCache.get((Object)table);
            if (brokers.isEmpty()) {
                throw new PinotException(PinotErrorCode.PINOT_UNABLE_TO_FIND_BROKER, Optional.empty(), "No valid brokers found for " + table);
            }
            return (String)brokers.get(ThreadLocalRandom.current().nextInt(brokers.size()));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof PinotException) {
                throw (PinotException)((Object)throwable);
            }
            throw new PinotException(PinotErrorCode.PINOT_UNABLE_TO_FIND_BROKER, Optional.empty(), "Error when getting brokers for table " + table, throwable);
        }
    }

    public Map<String, Map<String, List<String>>> getRoutingTableForTable(String tableName) {
        log.debug("Trying to get routingTable for %s from broker", new Object[]{tableName});
        String responseBody = this.sendHttpGetToBroker(tableName, String.format(ROUTING_TABLE_API_TEMPLATE, tableName));
        try {
            return ((RoutingTablesV2)this.routingTablesV2JsonCodec.fromJson(responseBody)).getRoutingTable();
        }
        catch (Exception e) {
            return this.getRoutingTableV1(tableName, responseBody);
        }
    }

    private Map<String, Map<String, List<String>>> getRoutingTableV1(String tableName, String responseBody) {
        ImmutableMap.Builder routingTableMap = ImmutableMap.builder();
        ((RoutingTables)this.routingTablesJsonCodec.fromJson(responseBody)).getRoutingTableSnapshot().forEach(snapshot -> {
            String tableNameWithType = snapshot.getTableName();
            if (!tableName.equals(TableNameBuilder.extractRawTableName((String)tableNameWithType))) {
                log.debug("Ignoring routingTable for %s", new Object[]{tableNameWithType});
            } else {
                List<Map<String, List<String>>> routingTableEntriesList = snapshot.getRoutingTableEntries();
                if (routingTableEntriesList.isEmpty()) {
                    throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.empty(), String.format("Empty routingTableEntries for %s. RoutingTable: %s", tableName, responseBody));
                }
                Map<String, List<String>> routingTableEntries = routingTableEntriesList.get(new Random().nextInt(routingTableEntriesList.size()));
                ImmutableMap.Builder routingTableBuilder = ImmutableMap.builder();
                routingTableEntries.forEach((host, segments) -> {
                    ArrayList segmentsCopied = new ArrayList(segments);
                    Collections.shuffle(segmentsCopied);
                    routingTableBuilder.put(host, (Object)ImmutableList.copyOf(segmentsCopied));
                });
                routingTableMap.put((Object)tableNameWithType, (Object)routingTableBuilder.build());
            }
        });
        return routingTableMap.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pinotConfig", (Object)this.pinotConfig).toString();
    }

    public TimeBoundary getTimeBoundaryForTable(String table) {
        try {
            String responseBody = this.sendHttpGetToBroker(table, String.format(TIME_BOUNDARY_API_TEMPLATE, table));
            return (TimeBoundary)this.timeBoundaryJsonCodec.fromJson(responseBody);
        }
        catch (Exception e) {
            String[] errorMessageSplits;
            if (e instanceof PinotException && (errorMessageSplits = e.getMessage().split(" ")).length >= 4 && errorMessageSplits[3].equalsIgnoreCase(TIME_BOUNDARY_NOT_FOUND_ERROR_CODE)) {
                return (TimeBoundary)this.timeBoundaryJsonCodec.fromJson("{}");
            }
            throw e;
        }
    }

    public Instance getInstance(String instanceName) {
        try {
            String responseBody = this.sendHttpGetToController(String.format(INSTANCE_API_TEMPLATE, instanceName));
            return (Instance)this.instanceJsonCodec.fromJson(responseBody);
        }
        catch (Exception throwable) {
            throw new PinotException(PinotErrorCode.PINOT_UNABLE_TO_FIND_INSTANCE, Optional.empty(), "Error when fetching instance configs for " + instanceName, throwable);
        }
    }

    public int getGrpcPort(String serverInstance) {
        try {
            return ((Instance)this.instanceConfigCache.get((Object)serverInstance)).getGrpcPort();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PinotException) {
                throw (PinotException)((Object)cause);
            }
            throw new PinotException(PinotErrorCode.PINOT_UNABLE_TO_FIND_INSTANCE, Optional.empty(), "Error when getting instance config for " + serverInstance, cause);
        }
    }

    public static class Instance {
        private final String instanceName;
        private final String hostName;
        private final boolean enabled;
        private final int port;
        private final int grpcPort;
        private final List<String> tags;
        private final List<String> pools;

        @JsonCreator
        public Instance(@JsonProperty String instanceName, @JsonProperty String hostName, @JsonProperty boolean enabled, @JsonProperty int port, @JsonProperty int grpcPort, @JsonProperty List<String> tags, @JsonProperty List<String> pools) {
            this.instanceName = instanceName;
            this.hostName = hostName;
            this.enabled = enabled;
            this.port = port;
            this.grpcPort = grpcPort;
            this.tags = tags;
            this.pools = pools;
        }

        @JsonProperty
        public String getInstanceName() {
            return this.instanceName;
        }

        @JsonProperty
        public String getHostName() {
            return this.hostName;
        }

        @JsonProperty
        public boolean isEnabled() {
            return this.enabled;
        }

        @JsonProperty
        public int getPort() {
            return this.port;
        }

        @JsonProperty
        public int getGrpcPort() {
            return this.grpcPort;
        }

        @JsonProperty
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty
        public List<String> getPools() {
            return this.pools;
        }
    }

    public static class TimeBoundary {
        private final Optional<String> onlineTimePredicate;
        private final Optional<String> offlineTimePredicate;

        public TimeBoundary() {
            this(null, null);
        }

        @JsonCreator
        public TimeBoundary(@JsonProperty String timeColumn, @JsonProperty String timeValue) {
            if (timeColumn != null && timeValue != null) {
                this.offlineTimePredicate = Optional.of(String.format("%s < %s", timeColumn, timeValue));
                this.onlineTimePredicate = Optional.of(String.format("%s >= %s", timeColumn, timeValue));
            } else {
                this.onlineTimePredicate = Optional.empty();
                this.offlineTimePredicate = Optional.empty();
            }
        }

        public Optional<String> getOnlineTimePredicate() {
            return this.onlineTimePredicate;
        }

        public Optional<String> getOfflineTimePredicate() {
            return this.offlineTimePredicate;
        }
    }

    public static class RoutingTablesV2 {
        private final Map<String, Map<String, List<String>>> routingTable;

        @JsonCreator
        public RoutingTablesV2(Map<String, Map<String, List<String>>> routingTable) {
            this.routingTable = routingTable;
        }

        public Map<String, Map<String, List<String>>> getRoutingTable() {
            return this.routingTable;
        }
    }

    public static class RoutingTables {
        private final List<RoutingTableSnapshot> routingTableSnapshot;

        @JsonCreator
        public RoutingTables(@JsonProperty(value="routingTableSnapshot") List<RoutingTableSnapshot> routingTableSnapshot) {
            this.routingTableSnapshot = routingTableSnapshot;
        }

        public List<RoutingTableSnapshot> getRoutingTableSnapshot() {
            return this.routingTableSnapshot;
        }

        public static class RoutingTableSnapshot {
            private final String tableName;
            private final List<Map<String, List<String>>> routingTableEntries;

            @JsonCreator
            public RoutingTableSnapshot(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="routingTableEntries") List<Map<String, List<String>>> routingTableEntries) {
                this.tableName = Objects.requireNonNull(tableName, "table name is null");
                this.routingTableEntries = Objects.requireNonNull(routingTableEntries, "routing table entries is null");
            }

            @JsonProperty(value="tableName")
            public String getTableName() {
                return this.tableName;
            }

            @JsonProperty(value="routingTableEntries")
            public List<Map<String, List<String>>> getRoutingTableEntries() {
                return this.routingTableEntries;
            }
        }
    }

    public static class BrokersForTable {
        private final List<InstancesInBroker> brokers;

        @JsonCreator
        public BrokersForTable(@JsonProperty(value="brokers") List<InstancesInBroker> brokers) {
            this.brokers = brokers;
        }

        @JsonProperty(value="brokers")
        public List<InstancesInBroker> getBrokers() {
            return this.brokers;
        }

        public static class InstancesInBroker {
            private final List<String> instances;

            @JsonCreator
            public InstancesInBroker(@JsonProperty(value="instances") List<String> instances) {
                this.instances = instances;
            }

            @JsonProperty(value="instances")
            public List<String> getInstances() {
                return this.instances;
            }
        }
    }

    public static class GetTables {
        private final List<String> tables;

        @JsonCreator
        public GetTables(@JsonProperty(value="tables") List<String> tables) {
            this.tables = tables;
        }

        public List<String> getTables() {
            return this.tables;
        }
    }
}

