/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.pinot.PinotColumn;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.apache.pinot.spi.data.TimeGranularitySpec;

public class PinotColumnUtils {
    private static final String DAYS_SINCE_EPOCH_TIME_FORMAT = "1:DAYS:EPOCH";
    private static final String MILLISECONDS_SINCE_EPOCH_TIME_FORMAT = "1:MILLISECONDS:EPOCH";

    private PinotColumnUtils() {
    }

    public static List<PinotColumn> getPinotColumnsForPinotSchema(Schema pinotTableSchema, boolean inferDateType, boolean inferTimestampType) {
        return (List)pinotTableSchema.getColumnNames().stream().filter(columnName -> !columnName.startsWith("$")).map(columnName -> new PinotColumn((String)columnName, PinotColumnUtils.getPrestoTypeFromPinotType(pinotTableSchema.getFieldSpecFor(columnName), inferDateType, inferTimestampType), PinotColumnUtils.isNullableColumnFromPinotType(pinotTableSchema.getFieldSpecFor(columnName)), PinotColumnUtils.getCommentFromPinotType(pinotTableSchema.getFieldSpecFor(columnName)))).collect(ImmutableList.toImmutableList());
    }

    private static String getCommentFromPinotType(FieldSpec field) {
        return field.getFieldType().name();
    }

    private static boolean isNullableColumnFromPinotType(FieldSpec field) {
        return false;
    }

    public static Type getPrestoTypeFromPinotType(FieldSpec field, boolean inferDateType, boolean inferTimestampType) {
        if (field.isSingleValueField()) {
            switch (field.getFieldType()) {
                case TIME: {
                    TimeFieldSpec timeFieldSpec = (TimeFieldSpec)field;
                    TimeGranularitySpec outSpec = timeFieldSpec.getOutgoingGranularitySpec();
                    if (outSpec != null) {
                        if (outSpec.getTimeFormat().equalsIgnoreCase(DateTimeFieldSpec.TimeFormat.EPOCH.name())) {
                            if (inferDateType && TimeUnit.DAYS == outSpec.getTimeType() && outSpec.getTimeUnitSize() == 1) {
                                return DateType.DATE;
                            }
                            if (inferTimestampType && TimeUnit.MILLISECONDS == outSpec.getTimeType() && outSpec.getTimeUnitSize() == 1) {
                                return TimestampType.TIMESTAMP;
                            }
                        }
                    } else {
                        TimeGranularitySpec inSpec = timeFieldSpec.getIncomingGranularitySpec();
                        if (inferDateType && TimeUnit.DAYS == inSpec.getTimeType() && inSpec.getTimeUnitSize() == 1) {
                            return DateType.DATE;
                        }
                        if (inferTimestampType && TimeUnit.MILLISECONDS == inSpec.getTimeType() && inSpec.getTimeUnitSize() == 1) {
                            return TimestampType.TIMESTAMP;
                        }
                    }
                    return PinotColumnUtils.getPrestoTypeFromPinotType(field.getDataType());
                }
                case DATE_TIME: {
                    DateTimeFieldSpec dateTimeFieldSpec = (DateTimeFieldSpec)field;
                    if (inferDateType && dateTimeFieldSpec.getFormat().equalsIgnoreCase(DAYS_SINCE_EPOCH_TIME_FORMAT)) {
                        return DateType.DATE;
                    }
                    if (!inferTimestampType || !dateTimeFieldSpec.getFormat().equalsIgnoreCase(MILLISECONDS_SINCE_EPOCH_TIME_FORMAT)) break;
                    return TimestampType.TIMESTAMP;
                }
            }
            return PinotColumnUtils.getPrestoTypeFromPinotType(field.getDataType());
        }
        return new ArrayType(PinotColumnUtils.getPrestoTypeFromPinotType(field.getDataType()));
    }

    private static Type getPrestoTypeFromPinotType(FieldSpec.DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case DOUBLE: 
            case FLOAT: {
                return DoubleType.DOUBLE;
            }
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case BYTES: {
                return VarbinaryType.VARBINARY;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case JSON: {
                return JsonType.JSON;
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Not support type conversion for pinot data type: " + dataType);
    }
}

