/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.pinot.PinotConnector;
import com.facebook.presto.pinot.PinotHandleResolver;
import com.facebook.presto.pinot.PinotMetrics;
import com.facebook.presto.pinot.PinotModule;
import com.facebook.presto.pinot.PinotNodePartitioningProvider;
import com.facebook.presto.pinot.RebindSafeMBeanServer;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Objects;
import javax.management.MBeanServer;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.guice.MBeanModule;

public class PinotConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "pinot";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new PinotHandleResolver();
    }

    public Connector create(String connectorId, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MBeanModule(), new PinotModule(connectorId), binder -> {
                binder.bind(MBeanServer.class).toInstance((Object)new RebindSafeMBeanServer(ManagementFactory.getPlatformMBeanServer()));
                binder.bind(ConnectorId.class).toInstance((Object)new ConnectorId(connectorId));
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(FunctionMetadataManager.class).toInstance((Object)context.getFunctionMetadataManager());
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(RowExpressionService.class).toInstance((Object)context.getRowExpressionService());
                binder.bind(LogicalRowExpressions.class).toInstance((Object)new LogicalRowExpressions(context.getRowExpressionService().getDeterminismEvaluator(), context.getStandardFunctionResolution(), context.getFunctionMetadataManager()));
                binder.bind(StandardFunctionResolution.class).toInstance((Object)context.getStandardFunctionResolution());
                binder.bind(PinotMetrics.class).in(Scopes.SINGLETON);
                ExportBinder.newExporter((Binder)binder).export(PinotMetrics.class).as(ObjectNames.generatedNameOf(PinotMetrics.class, (String)connectorId));
                binder.bind(ConnectorNodePartitioningProvider.class).to(PinotNodePartitioningProvider.class).in(Scopes.SINGLETON);
            }});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(PinotConnector.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

