/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.ErrorType;

public enum PinotErrorCode implements ErrorCodeSupplier
{
    PINOT_UNSUPPORTED_COLUMN_TYPE(0, ErrorType.EXTERNAL),
    PINOT_QUERY_GENERATOR_FAILURE(1, ErrorType.INTERNAL_ERROR),
    PINOT_INSUFFICIENT_SERVER_RESPONSE(2, ErrorType.EXTERNAL, true),
    PINOT_EXCEPTION(3, ErrorType.EXTERNAL),
    PINOT_HTTP_ERROR(4, ErrorType.EXTERNAL),
    PINOT_UNEXPECTED_RESPONSE(5, ErrorType.EXTERNAL),
    PINOT_UNSUPPORTED_EXPRESSION(6, ErrorType.INTERNAL_ERROR),
    PINOT_UNABLE_TO_FIND_BROKER(7, ErrorType.EXTERNAL),
    PINOT_DECODE_ERROR(8, ErrorType.EXTERNAL),
    PINOT_INVALID_PQL_GENERATED(9, ErrorType.INTERNAL_ERROR),
    PINOT_INVALID_CONFIGURATION(10, ErrorType.INTERNAL_ERROR),
    PINOT_DATA_FETCH_EXCEPTION(11, ErrorType.EXTERNAL, true),
    PINOT_REQUEST_GENERATOR_FAILURE(12, ErrorType.INTERNAL_ERROR),
    PINOT_UNABLE_TO_FIND_INSTANCE(13, ErrorType.EXTERNAL),
    PINOT_INVALID_SEGMENT_QUERY_GENERATED(14, ErrorType.INTERNAL_ERROR),
    PINOT_PUSH_DOWN_QUERY_NOT_PRESENT(20, ErrorType.USER_ERROR),
    PINOT_UNCLASSIFIED_ERROR(100, ErrorType.EXTERNAL);

    private final ErrorCode errorCode;
    private final boolean retriable;

    private PinotErrorCode(int code, ErrorType type, boolean retriable) {
        this.errorCode = new ErrorCode(code + 0x5050000, this.name(), type);
        this.retriable = retriable;
    }

    private PinotErrorCode(int code, ErrorType type) {
        this(code, type, false);
    }

    public boolean isRetriable() {
        return this.retriable;
    }

    public ErrorCode toErrorCode() {
        return this.errorCode;
    }
}

