/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotBrokerPageSourcePql;
import com.facebook.presto.pinot.PinotBrokerPageSourceSql;
import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotSegmentPageSource;
import com.facebook.presto.pinot.PinotSegmentStreamingPageSource;
import com.facebook.presto.pinot.PinotSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.pinot.common.utils.grpc.GrpcQueryClient;
import org.apache.pinot.connector.presto.PinotScatterGatherQueryClient;
import org.apache.pinot.connector.presto.grpc.PinotStreamingQueryClient;

public class PinotPageSourceProvider
implements ConnectorPageSourceProvider {
    private final String connectorId;
    private final PinotConfig pinotConfig;
    private final PinotScatterGatherQueryClient pinotQueryClient;
    private final PinotStreamingQueryClient pinotStreamingQueryClient;
    private final PinotClusterInfoFetcher clusterInfoFetcher;
    private final ObjectMapper objectMapper;

    @Inject
    public PinotPageSourceProvider(ConnectorId connectorId, PinotConfig pinotConfig, PinotClusterInfoFetcher clusterInfoFetcher, ObjectMapper objectMapper) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.pinotConfig = Objects.requireNonNull(pinotConfig, "pinotConfig is null");
        this.pinotQueryClient = new PinotScatterGatherQueryClient(new PinotScatterGatherQueryClient.Config(pinotConfig.getIdleTimeout().toMillis(), pinotConfig.getThreadPoolSize(), pinotConfig.getMinConnectionsPerServer(), pinotConfig.getMaxBacklogPerServer(), pinotConfig.getMaxConnectionsPerServer()));
        this.pinotStreamingQueryClient = new PinotStreamingQueryClient(PinotPageSourceProvider.extractGrpcQueryClientConfig(pinotConfig));
        this.clusterInfoFetcher = Objects.requireNonNull(clusterInfoFetcher, "cluster info fetcher is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "object mapper is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, ConnectorTableLayoutHandle tableLayoutHandle, List<ColumnHandle> columns, SplitContext splitContext) {
        Objects.requireNonNull(split, "split is null");
        PinotSplit pinotSplit = (PinotSplit)split;
        Preconditions.checkArgument((boolean)pinotSplit.getConnectorId().equals(this.connectorId), (Object)"split is not for this connector");
        ArrayList<PinotColumnHandle> handles = new ArrayList<PinotColumnHandle>();
        for (ColumnHandle handle : columns) {
            handles.add((PinotColumnHandle)handle);
        }
        switch (pinotSplit.getSplitType()) {
            case SEGMENT: {
                if (this.pinotConfig.isUseStreamingForSegmentQueries() && pinotSplit.getGrpcPort().orElse(-1) > 0) {
                    return new PinotSegmentStreamingPageSource(session, this.pinotConfig, this.pinotStreamingQueryClient, pinotSplit, handles);
                }
                return new PinotSegmentPageSource(session, this.pinotConfig, this.pinotQueryClient, pinotSplit, handles);
            }
            case BROKER: {
                switch (pinotSplit.getBrokerPinotQuery().get().getFormat()) {
                    case SQL: {
                        return new PinotBrokerPageSourceSql(this.pinotConfig, session, pinotSplit.getBrokerPinotQuery().get(), handles, pinotSplit.getExpectedColumnHandles(), this.clusterInfoFetcher, this.objectMapper);
                    }
                    case PQL: {
                        return new PinotBrokerPageSourcePql(this.pinotConfig, session, pinotSplit.getBrokerPinotQuery().get(), handles, pinotSplit.getExpectedColumnHandles(), this.clusterInfoFetcher, this.objectMapper);
                    }
                }
            }
        }
        throw new UnsupportedOperationException("Unknown Pinot split type: " + (Object)((Object)pinotSplit.getSplitType()));
    }

    @VisibleForTesting
    static GrpcQueryClient.Config extractGrpcQueryClientConfig(PinotConfig config) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        target.put("usePlainText", !config.isUseSecureConnection());
        target.put("maxInboundMessageSizeBytes", config.getStreamingServerGrpcMaxInboundMessageBytes());
        if (config.isUseSecureConnection()) {
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.keystore.path", config.getGrpcTlsKeyStorePath());
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.keystore.password", config.getGrpcTlsKeyStorePassword());
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.keystore.type", config.getGrpcTlsKeyStoreType());
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.truststore.path", config.getGrpcTlsTrustStorePath());
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.truststore.password", config.getGrpcTlsTrustStorePassword());
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.truststore.type", config.getGrpcTlsTrustStoreType());
        }
        return new GrpcQueryClient.Config(target);
    }

    private static void setOrRemoveProperty(Map<String, Object> prop, String key, Object value) {
        if (value == null) {
            prop.remove(key);
        } else {
            prop.put(key, value);
        }
    }
}

