/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotTableHandle;
import com.facebook.presto.pinot.query.PinotFilterExpressionConverter;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.pinot.query.PinotQueryGeneratorContext;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class PinotPlanOptimizer
implements ConnectorPlanOptimizer {
    private final PinotQueryGenerator pinotQueryGenerator;
    private final TypeManager typeManager;
    private final FunctionMetadataManager functionMetadataManager;
    private final LogicalRowExpressions logicalRowExpressions;
    private final StandardFunctionResolution standardFunctionResolution;

    @Inject
    public PinotPlanOptimizer(PinotQueryGenerator pinotQueryGenerator, TypeManager typeManager, FunctionMetadataManager functionMetadataManager, LogicalRowExpressions logicalRowExpressions, StandardFunctionResolution standardFunctionResolution) {
        this.pinotQueryGenerator = Objects.requireNonNull(pinotQueryGenerator, "pinot query generator is null");
        this.typeManager = Objects.requireNonNull(typeManager, "type manager is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "function manager is null");
        this.logicalRowExpressions = Objects.requireNonNull(logicalRowExpressions, "logical row expressions is null");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standard function resolution is null");
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        return (PlanNode)maxSubplan.accept((PlanVisitor)new Visitor(session, idAllocator), null);
    }

    private static Optional<PinotTableHandle> getPinotTableHandle(TableScanNode tableScanNode) {
        ConnectorTableHandle connectorHandle;
        TableHandle table = tableScanNode.getTable();
        if (table != null && (connectorHandle = table.getConnectorHandle()) instanceof PinotTableHandle) {
            return Optional.of((PinotTableHandle)connectorHandle);
        }
        return Optional.empty();
    }

    private static Optional<TableScanNode> getOnlyPinotTable(Map<TableScanNode, Void> scanNodes) {
        TableScanNode tableScanNode;
        if (scanNodes.size() == 1 && PinotPlanOptimizer.getPinotTableHandle(tableScanNode = scanNodes.keySet().iterator().next()).isPresent()) {
            return Optional.of(tableScanNode);
        }
        return Optional.empty();
    }

    private static PlanNode replaceChildren(PlanNode node, List<PlanNode> children) {
        for (int i = 0; i < node.getSources().size(); ++i) {
            if (children.get(i) == node.getSources().get(i)) continue;
            return node.replaceChildren(children);
        }
        return node;
    }

    private class Visitor
    extends PlanVisitor<PlanNode, TableScanNode> {
        private final PlanNodeIdAllocator idAllocator;
        private final ConnectorSession session;
        private final IdentityHashMap<FilterNode, Void> filtersSplitUp = new IdentityHashMap();

        public Visitor(ConnectorSession session, PlanNodeIdAllocator idAllocator) {
            this.session = session;
            this.idAllocator = idAllocator;
        }

        private Optional<PlanNode> tryCreatingNewScanNode(PlanNode plan, TableScanNode tableScanNode) {
            if (tableScanNode == null) {
                return Optional.empty();
            }
            Optional<PinotQueryGenerator.PinotQueryGeneratorResult> pinotQuery = PinotPlanOptimizer.this.pinotQueryGenerator.generate(plan, this.session);
            if (!pinotQuery.isPresent()) {
                return Optional.empty();
            }
            PinotTableHandle pinotTableHandle = (PinotTableHandle)PinotPlanOptimizer.getPinotTableHandle(tableScanNode).orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_UNCLASSIFIED_ERROR, Optional.empty(), "Expected to find a pinot table handle"));
            PinotQueryGeneratorContext context = pinotQuery.get().getContext();
            TableHandle oldTableHandle = tableScanNode.getTable();
            LinkedHashMap<VariableReferenceExpression, PinotColumnHandle> assignments = context.getAssignments(pinotQuery.get().getGeneratedPinotQuery().getFormat() == PinotQueryGenerator.PinotQueryFormat.SQL);
            boolean isQueryShort = pinotQuery.get().getGeneratedPinotQuery().isQueryShort();
            TableHandle newTableHandle = new TableHandle(oldTableHandle.getConnectorId(), (ConnectorTableHandle)new PinotTableHandle(pinotTableHandle.getConnectorId(), pinotTableHandle.getSchemaName(), pinotTableHandle.getTableName(), Optional.of(isQueryShort), Optional.of(ImmutableList.copyOf(assignments.values())), Optional.of(pinotQuery.get().getGeneratedPinotQuery())), oldTableHandle.getTransaction(), oldTableHandle.getLayout());
            return Optional.of(new TableScanNode(tableScanNode.getSourceLocation(), this.idAllocator.getNextId(), newTableHandle, (List)ImmutableList.copyOf(assignments.keySet()), (Map)assignments.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> (ColumnHandle)e.getValue())), tableScanNode.getCurrentConstraint(), tableScanNode.getEnforcedConstraint()));
        }

        public PlanNode visitPlan(PlanNode node, TableScanNode context) {
            Map scanNodes = (Map)node.accept((PlanVisitor)new TableFindingVisitor(), null);
            TableScanNode tableScanNode = scanNodes.size() == 1 ? (TableScanNode)PinotPlanOptimizer.getOnlyPinotTable(scanNodes).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expected to find the pinot table handle for the scan node")) : null;
            Optional<PlanNode> pushedDownPlan = this.tryCreatingNewScanNode(node, tableScanNode);
            return pushedDownPlan.orElseGet(() -> PinotPlanOptimizer.replaceChildren(node, (List)node.getSources().stream().map(source -> (PlanNode)source.accept((PlanVisitor)this, (Object)tableScanNode)).collect(ImmutableList.toImmutableList())));
        }

        public PlanNode visitFilter(FilterNode node, TableScanNode context) {
            if (this.filtersSplitUp.containsKey(node)) {
                return this.visitPlan((PlanNode)node, context);
            }
            this.filtersSplitUp.put(node, null);
            FilterNode nodeToRecurseInto = node;
            ArrayList<RowExpression> pushable = new ArrayList<RowExpression>();
            ArrayList<RowExpression> nonPushable = new ArrayList<RowExpression>();
            PinotFilterExpressionConverter pinotFilterExpressionConverter = new PinotFilterExpressionConverter(PinotPlanOptimizer.this.typeManager, PinotPlanOptimizer.this.functionMetadataManager, PinotPlanOptimizer.this.standardFunctionResolution);
            for (RowExpression conjunct : LogicalRowExpressions.extractConjuncts((RowExpression)node.getPredicate())) {
                try {
                    conjunct.accept((RowExpressionVisitor)pinotFilterExpressionConverter, var -> new PinotQueryGeneratorContext.Selection(var.getName(), PinotQueryGeneratorContext.Origin.DERIVED));
                    pushable.add(conjunct);
                }
                catch (PinotException pe) {
                    nonPushable.add(conjunct);
                }
            }
            if (!pushable.isEmpty()) {
                FilterNode pushableFilter = new FilterNode(node.getSourceLocation(), this.idAllocator.getNextId(), node.getSource(), PinotPlanOptimizer.this.logicalRowExpressions.combineConjuncts(pushable));
                Optional nonPushableFilter = nonPushable.isEmpty() ? Optional.empty() : Optional.of(new FilterNode(node.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)pushableFilter, PinotPlanOptimizer.this.logicalRowExpressions.combineConjuncts(nonPushable)));
                this.filtersSplitUp.put(pushableFilter, null);
                if (nonPushableFilter.isPresent()) {
                    FilterNode nonPushableFilterNode = (FilterNode)nonPushableFilter.get();
                    this.filtersSplitUp.put(nonPushableFilterNode, null);
                    nodeToRecurseInto = nonPushableFilterNode;
                } else {
                    nodeToRecurseInto = pushableFilter;
                }
            }
            return this.visitFilter(nodeToRecurseInto, context);
        }
    }

    private static class TableFindingVisitor
    extends PlanVisitor<Map<TableScanNode, Void>, Void> {
        private TableFindingVisitor() {
        }

        public Map<TableScanNode, Void> visitPlan(PlanNode node, Void context) {
            IdentityHashMap<TableScanNode, Void> ret = new IdentityHashMap<TableScanNode, Void>();
            node.getSources().forEach(source -> ret.putAll((Map)source.accept((PlanVisitor)this, (Object)context)));
            return ret;
        }

        public Map<TableScanNode, Void> visitTableScan(TableScanNode node, Void context) {
            IdentityHashMap<TableScanNode, Void> ret = new IdentityHashMap<TableScanNode, Void>();
            ret.put(node, null);
            return ret;
        }
    }
}

