/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PinotPushdownUtils {
    public static final String PINOT_DISTINCT_COUNT_FUNCTION_NAME = "distinctCount";
    private static final String COUNT_FUNCTION_NAME = "count";
    private static final String DISTINCT_MASK = "$distinct";

    private PinotPushdownUtils() {
    }

    public static void checkSupported(boolean condition, String errorMessage, Object ... errorMessageArgs) {
        if (!condition) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format(errorMessage, errorMessageArgs));
        }
    }

    public static List<AggregationColumnNode> computeAggregationNodes(AggregationNode aggregationNode) {
        int groupByKeyIndex = 0;
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        for (VariableReferenceExpression outputColumn : aggregationNode.getOutputVariables()) {
            AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)aggregationNode.getAggregations().get(outputColumn);
            if (aggregation != null) {
                if (aggregation.getFilter().isPresent() || aggregation.isDistinct() || aggregation.getOrderBy().isPresent()) {
                    throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Unsupported aggregation node " + aggregationNode);
                }
                if (aggregation.getMask().isPresent()) {
                    if (aggregation.getCall().getDisplayName().equalsIgnoreCase(COUNT_FUNCTION_NAME) && ((VariableReferenceExpression)aggregation.getMask().get()).getName().contains(DISTINCT_MASK)) {
                        nodeBuilder.add((Object)new AggregationFunctionColumnNode(outputColumn, new CallExpression(aggregation.getCall().getSourceLocation(), PINOT_DISTINCT_COUNT_FUNCTION_NAME, aggregation.getCall().getFunctionHandle(), aggregation.getCall().getType(), aggregation.getCall().getArguments())));
                        continue;
                    }
                    throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Unsupported aggregation node with mask " + aggregationNode);
                }
                if (PinotPushdownUtils.handlePushDownSingleDistinctCount((ImmutableList.Builder<AggregationColumnNode>)nodeBuilder, aggregationNode, outputColumn, aggregation)) continue;
                nodeBuilder.add((Object)new AggregationFunctionColumnNode(outputColumn, aggregation.getCall()));
                continue;
            }
            VariableReferenceExpression inputColumn = (VariableReferenceExpression)aggregationNode.getGroupingKeys().get(groupByKeyIndex);
            nodeBuilder.add((Object)new GroupByColumnNode(inputColumn, outputColumn));
            ++groupByKeyIndex;
        }
        return nodeBuilder.build();
    }

    private static boolean handlePushDownSingleDistinctCount(ImmutableList.Builder<AggregationColumnNode> nodeBuilder, AggregationNode aggregationNode, VariableReferenceExpression outputColumn, AggregationNode.Aggregation aggregation) {
        if (!aggregation.getCall().getDisplayName().equalsIgnoreCase(COUNT_FUNCTION_NAME)) {
            return false;
        }
        List arguments = aggregation.getCall().getArguments();
        if (arguments.size() != 1) {
            return false;
        }
        RowExpression aggregationArgument = (RowExpression)arguments.get(0);
        if (!(aggregationNode.getSource() instanceof AggregationNode)) {
            return false;
        }
        AggregationNode sourceAggregationNode = (AggregationNode)aggregationNode.getSource();
        Set<String> sourceAggregationGroupSet = PinotPushdownUtils.getGroupKeys(sourceAggregationNode.getGroupingKeys());
        Set<String> aggregationGroupSet = PinotPushdownUtils.getGroupKeys(aggregationNode.getGroupingKeys());
        aggregationGroupSet.add(aggregationArgument.toString());
        if (!sourceAggregationGroupSet.containsAll(aggregationGroupSet) && aggregationGroupSet.containsAll(sourceAggregationGroupSet)) {
            return false;
        }
        nodeBuilder.add((Object)new AggregationFunctionColumnNode(outputColumn, new CallExpression(aggregation.getCall().getSourceLocation(), PINOT_DISTINCT_COUNT_FUNCTION_NAME, aggregation.getFunctionHandle(), aggregation.getCall().getType(), (List)ImmutableList.of((Object)aggregationArgument))));
        return true;
    }

    private static Set<String> getGroupKeys(List<VariableReferenceExpression> groupingKeys) {
        HashSet<String> groupKeySet = new HashSet<String>();
        groupingKeys.forEach(groupingKey -> groupKeySet.add(groupingKey.getName()));
        return groupKeySet;
    }

    public static LinkedHashMap<VariableReferenceExpression, SortOrder> getOrderingScheme(TopNNode topNNode) {
        LinkedHashMap<VariableReferenceExpression, SortOrder> orderingScheme = new LinkedHashMap<VariableReferenceExpression, SortOrder>();
        topNNode.getOrderingScheme().getOrderByVariables().forEach(value -> orderingScheme.put((VariableReferenceExpression)value, topNNode.getOrderingScheme().getOrdering(value)));
        return orderingScheme;
    }

    private static Number decodeDecimal(BigInteger unscaledValue, DecimalType type) {
        return new BigDecimal(unscaledValue, type.getScale(), new MathContext(type.getPrecision()));
    }

    public static String getLiteralAsString(ConstantExpression node) {
        Type type = node.getType();
        if (node.getValue() == null) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Null constant expression %s with value of type %s", node, type));
        }
        if (type instanceof BooleanType) {
            return String.valueOf((Boolean)node.getValue());
        }
        if (type instanceof BigintType || type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType) {
            Number number = (Number)node.getValue();
            return String.format("%d", number.longValue());
        }
        if (type instanceof DoubleType) {
            return node.getValue().toString();
        }
        if (type instanceof RealType) {
            Long number = (Long)node.getValue();
            return String.format("%f", Float.valueOf(Float.intBitsToFloat(number.intValue())));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                Preconditions.checkState((boolean)(node.getValue() instanceof Long));
                return PinotPushdownUtils.decodeDecimal(BigInteger.valueOf((Long)node.getValue()), decimalType).toString();
            }
            Preconditions.checkState((boolean)(node.getValue() instanceof Slice));
            Slice value = (Slice)node.getValue();
            return PinotPushdownUtils.decodeDecimal(Decimals.decodeUnscaledValue((Slice)value), decimalType).toString();
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return "'" + ((Slice)node.getValue()).toStringUtf8() + "'";
        }
        if (type instanceof TimestampType || type instanceof DateType) {
            return node.getValue().toString();
        }
        if (type instanceof TimestampWithTimeZoneType) {
            Long millisUtc = DateTimeEncoding.unpackMillisUtc((long)((Long)node.getValue()));
            return millisUtc.toString();
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Cannot handle the constant expression %s with value of type %s", node, type));
    }

    public static abstract class AggregationColumnNode {
        private final ExpressionType expressionType;
        private final VariableReferenceExpression outputColumn;

        public AggregationColumnNode(ExpressionType expressionType, VariableReferenceExpression outputColumn) {
            this.expressionType = expressionType;
            this.outputColumn = outputColumn;
        }

        public VariableReferenceExpression getOutputColumn() {
            return this.outputColumn;
        }

        public ExpressionType getExpressionType() {
            return this.expressionType;
        }
    }

    public static class AggregationFunctionColumnNode
    extends AggregationColumnNode {
        private final CallExpression callExpression;

        public AggregationFunctionColumnNode(VariableReferenceExpression output, CallExpression callExpression) {
            super(ExpressionType.AGGREGATE, output);
            this.callExpression = callExpression;
        }

        public CallExpression getCallExpression() {
            return this.callExpression;
        }

        public String toString() {
            return this.callExpression.toString();
        }
    }

    public static class GroupByColumnNode
    extends AggregationColumnNode {
        private final VariableReferenceExpression inputColumn;

        public GroupByColumnNode(VariableReferenceExpression inputColumn, VariableReferenceExpression output) {
            super(ExpressionType.GROUP_BY, output);
            this.inputColumn = inputColumn;
        }

        public VariableReferenceExpression getInputColumn() {
            return this.inputColumn;
        }

        public String toString() {
            return this.inputColumn.toString();
        }
    }

    public static enum ExpressionType {
        GROUP_BY,
        AGGREGATE;

    }
}

