/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.Page;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotSegmentPageSource;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.PinotSplit;
import com.facebook.presto.pinot.query.PinotProxyGrpcRequestBuilder;
import com.facebook.presto.spi.ConnectorSession;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.common.utils.grpc.GrpcRequestBuilder;
import org.apache.pinot.connector.presto.grpc.PinotStreamingQueryClient;
import org.apache.pinot.core.common.datatable.DataTableFactory;

public class PinotSegmentStreamingPageSource
extends PinotSegmentPageSource {
    private final PinotStreamingQueryClient pinotStreamingQueryClient;
    private Iterator<Server.ServerResponse> serverResponseIterator;
    private long completedPositions;

    public PinotSegmentStreamingPageSource(ConnectorSession session, PinotConfig pinotConfig, PinotStreamingQueryClient pinotStreamingQueryClient, PinotSplit split, List<PinotColumnHandle> columnHandles) {
        super(session, pinotConfig, null, split, columnHandles);
        this.pinotStreamingQueryClient = Objects.requireNonNull(pinotStreamingQueryClient, "pinotStreamingQueryClient is null");
    }

    @Override
    public boolean isFinished() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getNextPage() {
        if (this.closed) {
            return null;
        }
        if (this.serverResponseIterator == null) {
            this.serverResponseIterator = this.queryPinot(this.split);
        }
        ByteBuffer byteBuffer = null;
        try {
            if (this.serverResponseIterator.hasNext()) {
                String responseType;
                long startTimeNanos = System.nanoTime();
                Server.ServerResponse serverResponse = this.serverResponseIterator.next();
                this.readTimeNanos += System.nanoTime() - startTimeNanos;
                switch (responseType = serverResponse.getMetadataOrThrow("responseType")) {
                    case "data": {
                        this.estimatedMemoryUsageInBytes = serverResponse.getSerializedSize();
                        try {
                            byteBuffer = serverResponse.getPayload().asReadOnlyByteBuffer();
                            DataTable dataTable = DataTableFactory.getDataTable((ByteBuffer)byteBuffer);
                            PinotSegmentStreamingPageSource.checkExceptions(dataTable, this.split, PinotSessionProperties.isMarkDataFetchExceptionsAsRetriable(this.session));
                            this.currentDataTable = new PinotSegmentPageSource.PinotDataTableWithSize(dataTable, serverResponse.getSerializedSize());
                            break;
                        }
                        catch (IOException e) {
                            throw new PinotException(PinotErrorCode.PINOT_DATA_FETCH_EXCEPTION, this.split.getSegmentPinotQuery(), String.format("Encountered Pinot exceptions when fetching data table from Split: < %s >", this.split), e);
                        }
                    }
                    case "metadata": {
                        this.currentDataTable = null;
                        this.serverResponseIterator = null;
                        this.close();
                        Page page = null;
                        return page;
                    }
                    default: {
                        throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, this.split.getSegmentPinotQuery(), String.format("Encountered Pinot exceptions, unknown response type - %s", responseType));
                    }
                }
            }
            Page page = this.fillNextPage();
            this.completedPositions += (long)this.currentDataTable.getDataTable().getNumberOfRows();
            Page page2 = page;
            return page2;
        }
        finally {
            if (byteBuffer != null) {
                byteBuffer.clear();
            }
        }
    }

    private Iterator<Server.ServerResponse> queryPinot(PinotSplit split) {
        String sql = split.getSegmentPinotQuery().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_INVALID_SEGMENT_QUERY_GENERATED, Optional.empty(), "Expected the segment split to contain the pinot query"));
        String grpcHost = split.getGrpcHost().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_INVALID_SEGMENT_QUERY_GENERATED, Optional.empty(), "Expected the segment split to contain the grpc host"));
        int grpcPort = split.getGrpcPort().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_INVALID_SEGMENT_QUERY_GENERATED, Optional.empty(), "Expected the segment split to contain the grpc port"));
        if (grpcPort <= 0) {
            throw new PinotException(PinotErrorCode.PINOT_INVALID_SEGMENT_QUERY_GENERATED, Optional.empty(), "Expected the grpc port > 0 always");
        }
        PinotProxyGrpcRequestBuilder grpcRequestBuilder = new PinotProxyGrpcRequestBuilder().setSegments((List)split.getSegments()).setEnableStreaming(true).setBrokerId("presto-coordinator-grpc").addExtraMetadata(this.pinotConfig.getExtraGrpcMetadata()).setSql(sql);
        if (this.pinotConfig.isUseProxy()) {
            grpcRequestBuilder.setHostName(grpcHost).setPort(grpcPort);
            return this.pinotStreamingQueryClient.submit(this.pinotConfig.getGrpcHost(), this.pinotConfig.getGrpcPort(), (GrpcRequestBuilder)grpcRequestBuilder);
        }
        return this.pinotStreamingQueryClient.submit(grpcHost, grpcPort, (GrpcRequestBuilder)grpcRequestBuilder);
    }

    @Override
    public long getCompletedPositions() {
        return this.completedPositions;
    }
}

