/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import javax.inject.Inject;

public class PinotSessionProperties {
    public static final String CONNECTION_TIMEOUT = "connection_timeout";
    public static final String FORBID_BROKER_QUERIES = "forbid_broker_queries";
    public static final String IGNORE_EMPTY_RESPONSES = "ignore_empty_responses";
    public static final String RETRY_COUNT = "retry_count";
    public static final String MARK_DATA_FETCH_EXCEPTIONS_AS_RETRIABLE = "mark_data_fetch_exceptions_as_retriable";
    public static final String USE_DATE_TRUNC = "use_date_trunc";
    public static final String USE_PINOT_SQL_FOR_BROKER_QUERIES = "use_pinot_sql_for_broker_queries";
    public static final String NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES = "non_aggregate_limit_for_broker_queries";
    public static final String PUSHDOWN_TOPN_BROKER_QUERIES = "pushdown_topn_broker_queries";
    public static final String FORBID_SEGMENT_QUERIES = "forbid_segment_queries";
    public static final String NUM_SEGMENTS_PER_SPLIT = "num_segments_per_split";
    public static final String TOPN_LARGE = "topn_large";
    public static final String LIMIT_LARGE_FOR_SEGMENT = "limit_larger_for_segment";
    public static final String OVERRIDE_DISTINCT_COUNT_FUNCTION = "override_distinct_count_function";
    private final List<PropertyMetadata<?>> sessionProperties;

    public static int getNumSegmentsPerSplit(ConnectorSession session) {
        int segmentsPerSplit = (Integer)session.getProperty(NUM_SEGMENTS_PER_SPLIT, Integer.class);
        return segmentsPerSplit <= 0 ? Integer.MAX_VALUE : segmentsPerSplit;
    }

    public static boolean isForbidBrokerQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(FORBID_BROKER_QUERIES, Boolean.class);
    }

    public static boolean isForbidSegmentQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(FORBID_SEGMENT_QUERIES, Boolean.class);
    }

    public static Duration getConnectionTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(CONNECTION_TIMEOUT, Duration.class);
    }

    public static boolean isIgnoreEmptyResponses(ConnectorSession session) {
        return (Boolean)session.getProperty(IGNORE_EMPTY_RESPONSES, Boolean.class);
    }

    public static int getPinotRetryCount(ConnectorSession session) {
        return (Integer)session.getProperty(RETRY_COUNT, Integer.class);
    }

    public static boolean isMarkDataFetchExceptionsAsRetriable(ConnectorSession session) {
        return (Boolean)session.getProperty(MARK_DATA_FETCH_EXCEPTIONS_AS_RETRIABLE, Boolean.class);
    }

    public static boolean isUseDateTruncation(ConnectorSession session) {
        return (Boolean)session.getProperty(USE_DATE_TRUNC, Boolean.class);
    }

    public static boolean isUsePinotSqlForBrokerQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(USE_PINOT_SQL_FOR_BROKER_QUERIES, Boolean.class);
    }

    public static int getNonAggregateLimitForBrokerQueries(ConnectorSession session) {
        return (Integer)session.getProperty(NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES, Integer.class);
    }

    public static boolean getPushdownTopnBrokerQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(PUSHDOWN_TOPN_BROKER_QUERIES, Boolean.class);
    }

    public static int getTopNLarge(ConnectorSession session) {
        return (Integer)session.getProperty(TOPN_LARGE, Integer.class);
    }

    public static int getLimitLargerForSegment(ConnectorSession session) {
        return (Integer)session.getProperty(LIMIT_LARGE_FOR_SEGMENT, Integer.class);
    }

    public static String getOverrideDistinctCountFunction(ConnectorSession session) {
        return (String)session.getProperty(OVERRIDE_DISTINCT_COUNT_FUNCTION, String.class);
    }

    @Inject
    public PinotSessionProperties(PinotConfig pinotConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)FORBID_BROKER_QUERIES, (String)"Forbid queries to the broker", (Boolean)pinotConfig.isForbidBrokerQueries(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)FORBID_SEGMENT_QUERIES, (String)"Forbid segment queries", (Boolean)pinotConfig.isForbidSegmentQueries(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)IGNORE_EMPTY_RESPONSES, (String)"Ignore empty or missing pinot server responses", (Boolean)pinotConfig.isIgnoreEmptyResponses(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)RETRY_COUNT, (String)"Retry count for retriable pinot data fetch calls", (Integer)pinotConfig.getFetchRetryCount(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)MARK_DATA_FETCH_EXCEPTIONS_AS_RETRIABLE, (String)"Retry Pinot query on data fetch exceptions", (Boolean)pinotConfig.isMarkDataFetchExceptionsAsRetriable(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES, (String)"Max limit for non aggregate queries to the pinot broker", (Integer)pinotConfig.getNonAggregateLimitForBrokerQueries(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)LIMIT_LARGE_FOR_SEGMENT, (String)"Server query selection limit for large segment", (Integer)pinotConfig.getLimitLargeForSegment(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)TOPN_LARGE, (String)"Broker query group by limit", (Integer)pinotConfig.getTopNLarge(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)OVERRIDE_DISTINCT_COUNT_FUNCTION, (String)"Override distinct count function to another function name", (String)pinotConfig.getOverrideDistinctCountFunction(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)USE_DATE_TRUNC, (String)"Use the new UDF dateTrunc in pinot that is more presto compatible", (Boolean)pinotConfig.isUseDateTrunc(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)USE_PINOT_SQL_FOR_BROKER_QUERIES, (String)"Use Pinot SQL syntax and endpoint for broker query", (Boolean)pinotConfig.isUsePinotSqlForBrokerQueries(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PUSHDOWN_TOPN_BROKER_QUERIES, (String)"Push down order by to pinot broker for top queries", (Boolean)pinotConfig.isPushdownTopNBrokerQueries(), (boolean)false), (Object[])new PropertyMetadata[]{new PropertyMetadata(CONNECTION_TIMEOUT, "Connection Timeout to talk to Pinot servers", (Type)VarcharType.createUnboundedVarcharType(), Duration.class, (Object)pinotConfig.getConnectionTimeout(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(NUM_SEGMENTS_PER_SPLIT, "Number of segments of the same host per split", (Type)IntegerType.INTEGER, Integer.class, (Object)pinotConfig.getNumSegmentsPerSplit(), false, value -> {
            int ret = ((Number)value).intValue();
            Preconditions.checkArgument((ret > 0 ? 1 : 0) != 0, (Object)"Number of segments per split must be more than zero");
            return ret;
        }, object -> object)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }
}

