/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.query;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotPushdownUtils;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.PinotTableHandle;
import com.facebook.presto.pinot.query.PinotAggregationProjectConverter;
import com.facebook.presto.pinot.query.PinotExpression;
import com.facebook.presto.pinot.query.PinotFilterExpressionConverter;
import com.facebook.presto.pinot.query.PinotProjectExpressionConverter;
import com.facebook.presto.pinot.query.PinotQueryGeneratorContext;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class PinotQueryGenerator {
    private static final Logger log = Logger.get(PinotQueryGenerator.class);
    private static final double LOWEST_APPROX_DISTINCT_MAX_STANDARD_ERROR = 0.0040625;
    private static final double HIGHEST_APPROX_DISTINCT_MAX_STANDARD_ERROR = 0.26;
    private static final Map<String, String> UNARY_AGGREGATION_MAP = ImmutableMap.builder().put((Object)"min", (Object)"min").put((Object)"max", (Object)"max").put((Object)"avg", (Object)"avg").put((Object)"sum", (Object)"sum").put((Object)"distinctcount", (Object)"DISTINCTCOUNT").build();
    private final PinotConfig pinotConfig;
    private final TypeManager typeManager;
    private final FunctionMetadataManager functionMetadataManager;
    private final StandardFunctionResolution standardFunctionResolution;
    private final PinotFilterExpressionConverter pinotFilterExpressionConverter;
    private final PinotProjectExpressionConverter pinotProjectExpressionConverter;

    @Inject
    public PinotQueryGenerator(PinotConfig pinotConfig, TypeManager typeManager, FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution) {
        this.pinotConfig = Objects.requireNonNull(pinotConfig, "pinot config is null");
        this.typeManager = Objects.requireNonNull(typeManager, "type manager is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "function metadata manager is null");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standardFunctionResolution is null");
        this.pinotFilterExpressionConverter = new PinotFilterExpressionConverter(this.typeManager, this.functionMetadataManager, standardFunctionResolution);
        this.pinotProjectExpressionConverter = new PinotProjectExpressionConverter(typeManager, standardFunctionResolution);
    }

    public Optional<PinotQueryGeneratorResult> generate(PlanNode plan, ConnectorSession session) {
        try {
            boolean usePinotSqlSyntax = PinotSessionProperties.isUsePinotSqlForBrokerQueries(session);
            PinotQueryGeneratorContext context = (PinotQueryGeneratorContext)Objects.requireNonNull(plan.accept((PlanVisitor)new PinotQueryPlanVisitor(session), (Object)new PinotQueryGeneratorContext(usePinotSqlSyntax)), "Resulting context is null");
            return Optional.of(new PinotQueryGeneratorResult(context.toQuery(this.pinotConfig, session), context));
        }
        catch (PinotException e) {
            log.debug((Throwable)((Object)e), "Possibly benign error when pushing plan into scan node %s", new Object[]{plan});
            return Optional.empty();
        }
    }

    class PinotQueryPlanVisitor
    extends PlanVisitor<PinotQueryGeneratorContext, PinotQueryGeneratorContext> {
        private final ConnectorSession session;
        private final boolean forbidBrokerQueries;
        private final boolean useSqlSyntax;
        private final boolean pushdownTopnBrokerQueries;

        protected PinotQueryPlanVisitor(ConnectorSession session) {
            this.session = session;
            this.forbidBrokerQueries = PinotSessionProperties.isForbidBrokerQueries(session);
            this.useSqlSyntax = PinotSessionProperties.isUsePinotSqlForBrokerQueries(session);
            this.pushdownTopnBrokerQueries = PinotSessionProperties.getPushdownTopnBrokerQueries(session);
        }

        public PinotQueryGeneratorContext visitPlan(PlanNode node, PinotQueryGeneratorContext context) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Don't know how to handle plan node of type " + node);
        }

        protected VariableReferenceExpression getVariableReference(RowExpression expression) {
            if (expression instanceof VariableReferenceExpression) {
                return (VariableReferenceExpression)expression;
            }
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Expected a variable reference but got " + expression);
        }

        public PinotQueryGeneratorContext visitMarkDistinct(MarkDistinctNode node, PinotQueryGeneratorContext context) {
            Objects.requireNonNull(context, "context is null");
            return (PinotQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public PinotQueryGeneratorContext visitFilter(FilterNode node, PinotQueryGeneratorContext context) {
            context = (PinotQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)context);
            Objects.requireNonNull(context, "context is null");
            Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> selections = context.getSelections();
            String filter = ((PinotExpression)node.getPredicate().accept((RowExpressionVisitor)PinotQueryGenerator.this.pinotFilterExpressionConverter, selections::get)).getDefinition();
            return context.withFilter(filter).withOutputColumns(node.getOutputVariables());
        }

        public PinotQueryGeneratorContext visitProject(ProjectNode node, PinotQueryGeneratorContext contextIn) {
            PinotQueryGeneratorContext context = (PinotQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)contextIn);
            Objects.requireNonNull(context, "context is null");
            HashMap<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> newSelections = new HashMap<VariableReferenceExpression, PinotQueryGeneratorContext.Selection>();
            LinkedHashSet<VariableReferenceExpression> newOutputs = new LinkedHashSet<VariableReferenceExpression>();
            node.getOutputVariables().forEach(variable -> {
                RowExpression expression = node.getAssignments().get(variable);
                PinotExpression pinotExpression = (PinotExpression)expression.accept((RowExpressionVisitor)(contextIn.getVariablesInAggregation().contains(variable) ? new PinotAggregationProjectConverter(PinotQueryGenerator.this.typeManager, PinotQueryGenerator.this.functionMetadataManager, PinotQueryGenerator.this.standardFunctionResolution, this.session, (VariableReferenceExpression)variable) : PinotQueryGenerator.this.pinotProjectExpressionConverter), context.getSelections());
                newSelections.put((VariableReferenceExpression)variable, new PinotQueryGeneratorContext.Selection(pinotExpression.getDefinition(), pinotExpression.getOrigin()));
                newOutputs.add((VariableReferenceExpression)variable);
            });
            if (this.useSqlSyntax) {
                newSelections.putAll(context.getSelections());
            }
            return context.withProject(newSelections, newOutputs);
        }

        public PinotQueryGeneratorContext visitTableScan(TableScanNode node, PinotQueryGeneratorContext contextIn) {
            PinotTableHandle tableHandle = (PinotTableHandle)node.getTable().getConnectorHandle();
            PinotPushdownUtils.checkSupported(!tableHandle.getPinotQuery().isPresent(), "Expect to see no existing pql", new Object[0]);
            PinotPushdownUtils.checkSupported(!tableHandle.getIsQueryShort().isPresent(), "Expect to see no existing pql", new Object[0]);
            HashMap<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> selections = new HashMap<VariableReferenceExpression, PinotQueryGeneratorContext.Selection>();
            LinkedHashSet<VariableReferenceExpression> outputs = new LinkedHashSet<VariableReferenceExpression>();
            node.getOutputVariables().forEach(outputColumn -> {
                PinotColumnHandle pinotColumn = (PinotColumnHandle)node.getAssignments().get(outputColumn);
                PinotPushdownUtils.checkSupported(pinotColumn.getType().equals((Object)PinotColumnHandle.PinotColumnType.REGULAR), "Unexpected pinot column handle that is not regular: %s", pinotColumn);
                selections.put((VariableReferenceExpression)outputColumn, new PinotQueryGeneratorContext.Selection(pinotColumn.getColumnName(), PinotQueryGeneratorContext.Origin.TABLE_COLUMN));
                outputs.add((VariableReferenceExpression)outputColumn);
            });
            return new PinotQueryGeneratorContext(selections, outputs, tableHandle.getTableName(), PinotSessionProperties.isUsePinotSqlForBrokerQueries(this.session));
        }

        private String handleAggregationFunction(CallExpression aggregation, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> inputSelections) {
            String prestoAggregation = aggregation.getDisplayName().toLowerCase(Locale.ENGLISH);
            List parameters = aggregation.getArguments();
            switch (prestoAggregation) {
                case "count": {
                    if (parameters.size() > 1) break;
                    return String.format("count(%s)", parameters.isEmpty() ? "*" : inputSelections.get(this.getVariableReference((RowExpression)parameters.get(0))));
                }
                case "approx_percentile": {
                    return this.handleApproxPercentile(aggregation, inputSelections);
                }
                case "approx_distinct": {
                    return this.handleApproxDistinct(aggregation, inputSelections);
                }
                default: {
                    if (!UNARY_AGGREGATION_MAP.containsKey(prestoAggregation) || aggregation.getArguments().size() != 1) break;
                    return String.format("%s(%s)", UNARY_AGGREGATION_MAP.get(prestoAggregation), inputSelections.get(this.getVariableReference((RowExpression)parameters.get(0))));
                }
            }
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("aggregation function '%s' not supported yet", aggregation));
        }

        private String handleApproxPercentile(CallExpression aggregation, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> inputSelections) {
            String fractionString;
            List inputs = aggregation.getArguments();
            if (inputs.size() != 2) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Cannot handle approx_percentile function " + aggregation);
            }
            RowExpression fractionInput = (RowExpression)inputs.get(1);
            if (fractionInput instanceof ConstantExpression) {
                fractionString = PinotPushdownUtils.getLiteralAsString((ConstantExpression)fractionInput);
            } else if (fractionInput instanceof VariableReferenceExpression) {
                PinotQueryGeneratorContext.Selection fraction = inputSelections.get(fractionInput);
                if (fraction.getOrigin() != PinotQueryGeneratorContext.Origin.LITERAL) {
                    throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Cannot handle approx_percentile percentage argument be a non literal " + aggregation);
                }
                fractionString = fraction.getDefinition();
            } else {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Expected the fraction to be a constant or a variable " + fractionInput);
            }
            int percentile = this.getValidPercentile(fractionString);
            if (percentile < 0) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Cannot handle approx_percentile parsed as %d from input %s (function %s)", percentile, fractionString, aggregation));
            }
            return String.format("PERCENTILEEST%d(%s)", percentile, inputSelections.get(this.getVariableReference((RowExpression)inputs.get(0))));
        }

        private String handleApproxDistinct(CallExpression aggregation, Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> inputSelections) {
            double standardError;
            String standardErrorString;
            List inputs = aggregation.getArguments();
            if (inputs.isEmpty() || inputs.size() > 2) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Cannot handle approx_distinct function " + aggregation);
            }
            PinotQueryGeneratorContext.Selection selection = inputSelections.get(this.getVariableReference((RowExpression)inputs.get(0)));
            if (inputs.size() == 1) {
                return String.format("DISTINCTCOUNTHLL(%s)", selection);
            }
            RowExpression standardErrorInput = (RowExpression)inputs.get(1);
            if (standardErrorInput instanceof ConstantExpression) {
                standardErrorString = PinotPushdownUtils.getLiteralAsString((ConstantExpression)standardErrorInput);
            } else if (standardErrorInput instanceof VariableReferenceExpression) {
                PinotQueryGeneratorContext.Selection fraction = inputSelections.get(standardErrorInput);
                if (fraction.getOrigin() != PinotQueryGeneratorContext.Origin.LITERAL) {
                    throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Cannot handle approx_distinct standard error argument be a non literal " + aggregation);
                }
                standardErrorString = fraction.getDefinition();
            } else {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Expected the standard error to be a constant or a variable " + standardErrorInput);
            }
            try {
                standardError = Double.parseDouble(standardErrorString);
                if (standardError <= 0.0040625 || standardError >= 0.26) {
                    throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Cannot handle approx_distinct parsed as %f from input %s (function %s)", standardError, standardErrorString, aggregation));
                }
            }
            catch (Exception e) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Cannot handle approx_distinct parsing to numerical value from input %s (function %s)", standardErrorString, aggregation));
            }
            int log2m = (int)(2.0 * Math.log(1.106 / standardError) / Math.log(2.0));
            if (log2m < 1) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Cannot handle approx_distinct, the log2m generated from error is %d from input %s (function %s)", log2m, standardErrorString, aggregation));
            }
            return String.format("DISTINCTCOUNTHLL(%s, %d)", selection, log2m);
        }

        private int getValidPercentile(String fraction) {
            try {
                double percent = Double.parseDouble(fraction);
                if (percent < 0.0 || percent > 1.0) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1");
                }
                if ((percent *= 100.0) == Math.floor(percent)) {
                    return (int)percent;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return -1;
        }

        public PinotQueryGeneratorContext visitAggregation(AggregationNode node, PinotQueryGeneratorContext contextIn) {
            List<PinotPushdownUtils.AggregationColumnNode> aggregationColumnNodes = PinotPushdownUtils.computeAggregationNodes(node);
            HashSet<VariableReferenceExpression> variablesInAggregation = new HashSet<VariableReferenceExpression>();
            block8: for (PinotPushdownUtils.AggregationColumnNode expression : aggregationColumnNodes) {
                switch (expression.getExpressionType()) {
                    case GROUP_BY: {
                        PinotPushdownUtils.GroupByColumnNode groupByColumn = (PinotPushdownUtils.GroupByColumnNode)expression;
                        VariableReferenceExpression groupByInputColumn = this.getVariableReference((RowExpression)groupByColumn.getInputColumn());
                        Preconditions.checkState((groupByInputColumn.getType() instanceof FixedWidthType || groupByInputColumn.getType() instanceof VarcharType || groupByInputColumn.getType() instanceof JsonType ? 1 : 0) != 0);
                        variablesInAggregation.add(groupByInputColumn);
                        continue block8;
                    }
                    case AGGREGATE: {
                        PinotPushdownUtils.AggregationFunctionColumnNode aggregationNode = (PinotPushdownUtils.AggregationFunctionColumnNode)expression;
                        variablesInAggregation.addAll(aggregationNode.getCallExpression().getArguments().stream().filter(argument -> argument instanceof VariableReferenceExpression).map(argument -> (VariableReferenceExpression)argument).collect(Collectors.toList()));
                        continue block8;
                    }
                }
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "unknown aggregation expression: " + (Object)((Object)expression.getExpressionType()));
            }
            PinotQueryGeneratorContext context = (PinotQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)contextIn.withVariablesInAggregation(variablesInAggregation));
            Objects.requireNonNull(context, "context is null");
            PinotPushdownUtils.checkSupported(!node.getStep().isOutputPartial(), "partial aggregations are not supported in Pinot pushdown framework", new Object[0]);
            PinotPushdownUtils.checkSupported(!this.forbidBrokerQueries, "Cannot push aggregation in segment mode", new Object[0]);
            HashMap<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> newSelections = new HashMap<VariableReferenceExpression, PinotQueryGeneratorContext.Selection>();
            LinkedHashSet<VariableReferenceExpression> outputs = new LinkedHashSet<VariableReferenceExpression>();
            LinkedHashSet<VariableReferenceExpression> groupByColumns = new LinkedHashSet<VariableReferenceExpression>();
            HashSet<VariableReferenceExpression> hiddenColumnSet = new HashSet<VariableReferenceExpression>(context.getHiddenColumnSet());
            int aggregations = 0;
            boolean groupByExists = false;
            block9: for (PinotPushdownUtils.AggregationColumnNode expression : aggregationColumnNodes) {
                switch (expression.getExpressionType()) {
                    case GROUP_BY: {
                        PinotPushdownUtils.GroupByColumnNode groupByColumn = (PinotPushdownUtils.GroupByColumnNode)expression;
                        VariableReferenceExpression groupByInputColumn = this.getVariableReference((RowExpression)groupByColumn.getInputColumn());
                        VariableReferenceExpression outputColumn = this.getVariableReference((RowExpression)groupByColumn.getOutputColumn());
                        PinotQueryGeneratorContext.Selection pinotColumn = Objects.requireNonNull(context.getSelections().get(groupByInputColumn), "Group By column " + groupByInputColumn + " doesn't exist in input " + context.getSelections());
                        newSelections.put(outputColumn, new PinotQueryGeneratorContext.Selection(pinotColumn.getDefinition(), pinotColumn.getOrigin()));
                        groupByColumns.add(outputColumn);
                        outputs.add(outputColumn);
                        groupByExists = true;
                        continue block9;
                    }
                    case AGGREGATE: {
                        PinotPushdownUtils.AggregationFunctionColumnNode aggregationNode = (PinotPushdownUtils.AggregationFunctionColumnNode)expression;
                        String pinotAggFunction = this.handleAggregationFunction(aggregationNode.getCallExpression(), context.getSelections());
                        VariableReferenceExpression aggregationVarRef = this.getVariableReference((RowExpression)aggregationNode.getOutputColumn());
                        newSelections.put(aggregationVarRef, new PinotQueryGeneratorContext.Selection(pinotAggFunction, PinotQueryGeneratorContext.Origin.DERIVED));
                        outputs.add(aggregationVarRef);
                        ++aggregations;
                        continue block9;
                    }
                }
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "unknown aggregation expression: " + (Object)((Object)expression.getExpressionType()));
            }
            if (!this.useSqlSyntax && groupByExists && aggregations == 0) {
                this.setHiddenField(newSelections, outputs, hiddenColumnSet);
                ++aggregations;
            }
            return context.withAggregation(newSelections, outputs, groupByColumns, aggregations, hiddenColumnSet);
        }

        public PinotQueryGeneratorContext visitLimit(LimitNode node, PinotQueryGeneratorContext context) {
            PinotPushdownUtils.checkSupported(!node.isPartial(), String.format("pinot query generator cannot handle partial limit", new Object[0]), new Object[0]);
            PinotPushdownUtils.checkSupported(!this.forbidBrokerQueries, "Cannot push limit in segment mode", new Object[0]);
            context = (PinotQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)context);
            Objects.requireNonNull(context, "context is null");
            return context.withLimit(node.getCount()).withOutputColumns(node.getOutputVariables());
        }

        public PinotQueryGeneratorContext visitTopN(TopNNode node, PinotQueryGeneratorContext context) {
            context = (PinotQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)context);
            Objects.requireNonNull(context, "context is null");
            PinotPushdownUtils.checkSupported(!this.forbidBrokerQueries, "Cannot push topn in segment mode", new Object[0]);
            PinotPushdownUtils.checkSupported(node.getStep().equals((Object)TopNNode.Step.SINGLE), "Can only push single logical topn in", new Object[0]);
            if (this.pushdownTopnBrokerQueries) {
                return context.withTopN(PinotPushdownUtils.getOrderingScheme(node), node.getCount()).withOutputColumns(node.getOutputVariables());
            }
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "TopN query is not allowed to push down. Please refer to config: 'pinot.pushdown-topn-broker-queries'");
        }

        public PinotQueryGeneratorContext visitDistinctLimit(DistinctLimitNode node, PinotQueryGeneratorContext context) {
            context = (PinotQueryGeneratorContext)node.getSource().accept((PlanVisitor)this, (Object)context);
            Objects.requireNonNull(context, "context is null");
            PinotPushdownUtils.checkSupported(!this.forbidBrokerQueries, "Cannot push distinctLimit in segment mode", new Object[0]);
            LinkedHashSet<VariableReferenceExpression> groupByColumns = new LinkedHashSet<VariableReferenceExpression>(node.getDistinctVariables());
            if (!this.useSqlSyntax) {
                PinotPushdownUtils.checkSupported(!context.hasAggregation(), "Aggregation already exists. Pinot doesn't support DistinctLimit with existing Aggregation", new Object[0]);
                PinotPushdownUtils.checkSupported(!context.hasGroupBy(), "GroupBy already exists. Pinot doesn't support DistinctLimit with existing GroupBy", new Object[0]);
                HashMap<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> newSelections = new HashMap<VariableReferenceExpression, PinotQueryGeneratorContext.Selection>(context.getSelections());
                LinkedHashSet<VariableReferenceExpression> newOutputs = new LinkedHashSet<VariableReferenceExpression>(groupByColumns);
                HashSet<VariableReferenceExpression> hiddenColumnSet = new HashSet<VariableReferenceExpression>();
                this.setHiddenField(newSelections, newOutputs, hiddenColumnSet);
                return context.withAggregation(newSelections, newOutputs, groupByColumns, 1, hiddenColumnSet).withLimit(node.getLimit());
            }
            return context.withDistinctLimit(groupByColumns, node.getLimit()).withOutputColumns(node.getOutputVariables());
        }

        private void setHiddenField(Map<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> selections, LinkedHashSet<VariableReferenceExpression> outputs, Set<VariableReferenceExpression> hiddenColumnSet) {
            VariableReferenceExpression hidden = new VariableReferenceExpression(Optional.empty(), UUID.randomUUID().toString(), (Type)BigintType.BIGINT);
            selections.put(hidden, new PinotQueryGeneratorContext.Selection("count(*)", PinotQueryGeneratorContext.Origin.DERIVED));
            outputs.add(hidden);
            hiddenColumnSet.add(hidden);
        }
    }

    public static class GeneratedPinotQuery {
        final String table;
        final String query;
        final PinotQueryFormat format;
        final List<Integer> expectedColumnIndices;
        final int groupByClauses;
        final boolean haveFilter;
        final boolean isQueryShort;

        @JsonCreator
        public GeneratedPinotQuery(@JsonProperty(value="table") String table, @JsonProperty(value="query") String query, @JsonProperty(value="format") PinotQueryFormat format, @JsonProperty(value="expectedColumnIndices") List<Integer> expectedColumnIndices, @JsonProperty(value="groupByClauses") int groupByClauses, @JsonProperty(value="haveFilter") boolean haveFilter, @JsonProperty(value="isQueryShort") boolean isQueryShort) {
            this.table = table;
            this.query = query;
            this.format = format;
            Preconditions.checkState((query != null ? 1 : 0) != 0, (Object)"Expected only one of query to be present");
            this.expectedColumnIndices = expectedColumnIndices;
            this.groupByClauses = groupByClauses;
            this.haveFilter = haveFilter;
            this.isQueryShort = isQueryShort;
        }

        @JsonProperty(value="table")
        public String getTable() {
            return this.table;
        }

        @JsonProperty(value="query")
        public String getQuery() {
            return this.query;
        }

        @JsonProperty(value="format")
        public PinotQueryFormat getFormat() {
            return this.format;
        }

        @JsonProperty(value="expectedColumnIndices")
        public List<Integer> getExpectedColumnIndices() {
            return this.expectedColumnIndices;
        }

        @JsonProperty(value="groupByClauses")
        public int getGroupByClauses() {
            return this.groupByClauses;
        }

        @JsonProperty(value="haveFilter")
        public boolean isHaveFilter() {
            return this.haveFilter;
        }

        @JsonProperty(value="isQueryShort")
        public boolean isQueryShort() {
            return this.isQueryShort;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("query", (Object)this.query).add("format", (Object)this.format).add("table", (Object)this.table).add("expectedColumnIndices", this.expectedColumnIndices).add("groupByClauses", this.groupByClauses).add("haveFilter", this.haveFilter).add("isQueryShort", this.isQueryShort).toString();
        }
    }

    public static enum PinotQueryFormat {
        PQL,
        SQL;

    }

    public static class PinotQueryGeneratorResult {
        private final GeneratedPinotQuery generatedPinotQuery;
        private final PinotQueryGeneratorContext context;

        public PinotQueryGeneratorResult(GeneratedPinotQuery generatedPinotQuery, PinotQueryGeneratorContext context) {
            this.generatedPinotQuery = Objects.requireNonNull(generatedPinotQuery, "generatedPinotQuery is null");
            this.context = Objects.requireNonNull(context, "context is null");
        }

        public GeneratedPinotQuery getGeneratedPinotQuery() {
            return this.generatedPinotQuery;
        }

        public PinotQueryGeneratorContext getContext() {
            return this.context;
        }
    }
}

