/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.batchreader.AbstractNestedBatchReader;
import com.facebook.presto.parquet.batchreader.DefinitionLevelDecodingContext;
import com.facebook.presto.parquet.batchreader.RepetitionLevelDecodingContext;
import com.facebook.presto.parquet.batchreader.ValuesDecoderContext;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.reader.ColumnChunk;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;

public class BinaryNestedBatchReader
extends AbstractNestedBatchReader {
    public BinaryNestedBatchReader(RichColumnDescriptor columnDescriptor) {
        super(columnDescriptor);
    }

    @Override
    protected ColumnChunk readNestedWithNull() throws IOException {
        int maxDefinitionLevel = this.columnDescriptor.getMaxDefinitionLevel();
        RepetitionLevelDecodingContext repetitionLevelDecodingContext = this.readRepetitionLevels(this.nextBatchSize);
        DefinitionLevelDecodingContext definitionLevelDecodingContext = this.readDefinitionLevels(repetitionLevelDecodingContext.getDLValuesDecoderContexts(), repetitionLevelDecodingContext.getRepetitionLevels().length);
        int[] definitionLevels = definitionLevelDecodingContext.getDefinitionLevels();
        int newBatchSize = 0;
        int batchNonNullCount = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            int nonNullCount = 0;
            int valueCount = 0;
            for (int i = valuesDecoderContext.getStart(); i < valuesDecoderContext.getEnd(); ++i) {
                nonNullCount += definitionLevels[i] == maxDefinitionLevel ? 1 : 0;
                valueCount += definitionLevels[i] >= maxDefinitionLevel - 1 ? 1 : 0;
            }
            batchNonNullCount += nonNullCount;
            newBatchSize += valueCount;
            valuesDecoderContext.setNonNullCount(nonNullCount);
            valuesDecoderContext.setValueCount(valueCount);
        }
        if (batchNonNullCount == 0) {
            Block block = RunLengthEncodedBlock.create((Type)this.field.getType(), null, (int)newBatchSize);
            return new ColumnChunk(block, definitionLevels, repetitionLevelDecodingContext.getRepetitionLevels());
        }
        ArrayList<ValuesDecoder.BinaryValuesDecoder.ValueBuffer> valueBuffers = new ArrayList<ValuesDecoder.BinaryValuesDecoder.ValueBuffer>();
        int bufferSize = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer = ((ValuesDecoder.BinaryValuesDecoder)valuesDecoderContext.getValuesDecoder()).readNext(valuesDecoderContext.getNonNullCount());
            bufferSize += valueBuffer.getBufferSize();
            valueBuffers.add(valueBuffer);
        }
        byte[] byteBuffer = new byte[bufferSize];
        int[] offsets = new int[newBatchSize + 1];
        int i = 0;
        int bufferIndex = 0;
        int offsetIndex = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            ValuesDecoder.BinaryValuesDecoder.ValueBuffer value = (ValuesDecoder.BinaryValuesDecoder.ValueBuffer)valueBuffers.get(i);
            bufferIndex = ((ValuesDecoder.BinaryValuesDecoder)valuesDecoderContext.getValuesDecoder()).readIntoBuffer(byteBuffer, bufferIndex, offsets, offsetIndex, value);
            offsetIndex += valuesDecoderContext.getValueCount();
            ++i;
        }
        boolean[] isNull = new boolean[newBatchSize];
        int offset = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            int destinationIndex = offset + valuesDecoderContext.getValueCount() - 1;
            int sourceIndex = offset + valuesDecoderContext.getNonNullCount() - 1;
            int definitionLevelIndex = valuesDecoderContext.getEnd() - 1;
            offsets[destinationIndex + 1] = offsets[sourceIndex + 1];
            while (destinationIndex >= offset) {
                if (definitionLevels[definitionLevelIndex] == maxDefinitionLevel) {
                    offsets[destinationIndex--] = offsets[sourceIndex--];
                } else if (definitionLevels[definitionLevelIndex] == maxDefinitionLevel - 1) {
                    offsets[destinationIndex] = offsets[sourceIndex + 1];
                    isNull[destinationIndex] = true;
                    --destinationIndex;
                }
                --definitionLevelIndex;
            }
            offset += valuesDecoderContext.getValueCount();
        }
        Slice buffer = Slices.wrappedBuffer((byte[])byteBuffer, (int)0, (int)bufferSize);
        boolean hasNoNull = batchNonNullCount == newBatchSize;
        VariableWidthBlock block = new VariableWidthBlock(newBatchSize, buffer, offsets, hasNoNull ? Optional.empty() : Optional.of(isNull));
        return new ColumnChunk((Block)block, definitionLevels, repetitionLevelDecodingContext.getRepetitionLevels());
    }

    @Override
    protected ColumnChunk readNestedNoNull() throws IOException {
        int maxDefinitionLevel = this.columnDescriptor.getMaxDefinitionLevel();
        RepetitionLevelDecodingContext repetitionLevelDecodingContext = this.readRepetitionLevels(this.nextBatchSize);
        DefinitionLevelDecodingContext definitionLevelDecodingContext = this.readDefinitionLevels(repetitionLevelDecodingContext.getDLValuesDecoderContexts(), repetitionLevelDecodingContext.getRepetitionLevels().length);
        int[] definitionLevels = definitionLevelDecodingContext.getDefinitionLevels();
        int newBatchSize = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            int valueCount = 0;
            for (int i = valuesDecoderContext.getStart(); i < valuesDecoderContext.getEnd(); ++i) {
                valueCount += definitionLevels[i] == maxDefinitionLevel ? 1 : 0;
            }
            newBatchSize += valueCount;
            valuesDecoderContext.setNonNullCount(valueCount);
            valuesDecoderContext.setValueCount(valueCount);
        }
        ArrayList<ValuesDecoder.BinaryValuesDecoder.ValueBuffer> valueBuffers = new ArrayList<ValuesDecoder.BinaryValuesDecoder.ValueBuffer>();
        int bufferSize = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer = ((ValuesDecoder.BinaryValuesDecoder)valuesDecoderContext.getValuesDecoder()).readNext(valuesDecoderContext.getNonNullCount());
            bufferSize += valueBuffer.getBufferSize();
            valueBuffers.add(valueBuffer);
        }
        byte[] byteBuffer = new byte[bufferSize];
        int[] offsets = new int[newBatchSize + 1];
        int i = 0;
        int bufferIndex = 0;
        int offsetIndex = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            ValuesDecoder.BinaryValuesDecoder.ValueBuffer value = (ValuesDecoder.BinaryValuesDecoder.ValueBuffer)valueBuffers.get(i);
            bufferIndex = ((ValuesDecoder.BinaryValuesDecoder)valuesDecoderContext.getValuesDecoder()).readIntoBuffer(byteBuffer, bufferIndex, offsets, offsetIndex, value);
            offsetIndex += valuesDecoderContext.getValueCount();
            ++i;
        }
        Slice buffer = Slices.wrappedBuffer((byte[])byteBuffer, (int)0, (int)bufferSize);
        VariableWidthBlock block = new VariableWidthBlock(newBatchSize, buffer, offsets, Optional.empty());
        return new ColumnChunk((Block)block, definitionLevels, repetitionLevelDecodingContext.getRepetitionLevels());
    }

    @Override
    protected void seek() throws IOException {
        if (this.readOffset == 0) {
            return;
        }
        int maxDefinitionLevel = this.columnDescriptor.getMaxDefinitionLevel();
        RepetitionLevelDecodingContext repetitionLevelDecodingContext = this.readRepetitionLevels(this.readOffset);
        DefinitionLevelDecodingContext definitionLevelDecodingContext = this.readDefinitionLevels(repetitionLevelDecodingContext.getDLValuesDecoderContexts(), repetitionLevelDecodingContext.getRepetitionLevels().length);
        int[] definitionLevels = definitionLevelDecodingContext.getDefinitionLevels();
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            int valueCount = 0;
            for (int i = valuesDecoderContext.getStart(); i < valuesDecoderContext.getEnd(); ++i) {
                valueCount += definitionLevels[i] == maxDefinitionLevel ? 1 : 0;
            }
            ValuesDecoder.BinaryValuesDecoder binaryValuesDecoder = (ValuesDecoder.BinaryValuesDecoder)valuesDecoderContext.getValuesDecoder();
            binaryValuesDecoder.skip(valueCount);
        }
    }
}

