/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.plain;

import com.facebook.presto.parquet.ParquetTimestampUtils;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.google.common.base.Preconditions;

public class TimestampPlainValuesDecoder
implements ValuesDecoder.TimestampValuesDecoder {
    private final byte[] byteBuffer;
    private final int bufferEnd;
    private int bufferOffset;

    public TimestampPlainValuesDecoder(byte[] byteBuffer, int bufferOffset, int bufferLength) {
        this.byteBuffer = byteBuffer;
        this.bufferEnd = bufferOffset + bufferLength;
        this.bufferOffset = bufferOffset;
    }

    @Override
    public void readNext(long[] values, int offset, int length) {
        Preconditions.checkArgument((this.bufferOffset + length * 12 <= this.bufferEnd ? 1 : 0) != 0, (Object)"End of stream: invalid read request");
        Preconditions.checkArgument((length >= 0 && offset >= 0 ? 1 : 0) != 0, (String)"invalid read request: offset %s, length", (int)offset, (int)length);
        int endOffset = offset + length;
        byte[] localByteBuffer = this.byteBuffer;
        int localBufferOffset = this.bufferOffset;
        while (offset < endOffset) {
            values[offset++] = ParquetTimestampUtils.getTimestampMillis(localByteBuffer, localBufferOffset);
            localBufferOffset += 12;
        }
        this.bufferOffset = localBufferOffset;
    }

    @Override
    public void skip(int length) {
        Preconditions.checkArgument((this.bufferOffset + length * 12 <= this.bufferEnd ? 1 : 0) != 0, (Object)"End of stream: invalid read request");
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        this.bufferOffset += length * 12;
    }
}

