/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.RootTabletLocator;
import org.apache.accumulo.core.client.impl.TabletLocatorImpl;
import org.apache.accumulo.core.client.impl.ZookeeperLockChecker;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataLocationObtainer;
import org.apache.hadoop.io.Text;

public abstract class TabletLocator {
    private static HashMap<LocatorKey, TabletLocator> locators = new HashMap();

    public abstract TabletLocation locateTablet(ClientContext var1, Text var2, boolean var3, boolean var4) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public abstract <T extends Mutation> void binMutations(ClientContext var1, List<T> var2, Map<String, TabletServerMutations<T>> var3, List<T> var4) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public abstract List<Range> binRanges(ClientContext var1, List<Range> var2, Map<String, Map<KeyExtent, List<Range>>> var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public abstract void invalidateCache(KeyExtent var1);

    public abstract void invalidateCache(Collection<KeyExtent> var1);

    public abstract void invalidateCache();

    public abstract void invalidateCache(Instance var1, String var2);

    public static synchronized void clearLocators() {
        locators.clear();
    }

    public static synchronized TabletLocator getLocator(ClientContext context, Text tableId) {
        Instance instance = context.getInstance();
        LocatorKey key = new LocatorKey(instance.getInstanceID(), tableId);
        TabletLocator tl = locators.get(key);
        if (tl == null) {
            MetadataLocationObtainer mlo = new MetadataLocationObtainer();
            tl = tableId.toString().equals("+r") ? new RootTabletLocator(new ZookeeperLockChecker(instance)) : (tableId.toString().equals("!0") ? new TabletLocatorImpl(new Text("!0"), TabletLocator.getLocator(context, new Text("+r")), mlo, new ZookeeperLockChecker(instance)) : new TabletLocatorImpl(tableId, TabletLocator.getLocator(context, new Text("!0")), mlo, new ZookeeperLockChecker(instance)));
            locators.put(key, tl);
        }
        return tl;
    }

    public static class TabletServerMutations<T extends Mutation> {
        private Map<KeyExtent, List<T>> mutations;
        private String tserverSession;

        public TabletServerMutations(String tserverSession) {
            this.tserverSession = tserverSession;
            this.mutations = new HashMap<KeyExtent, List<T>>();
        }

        public void addMutation(KeyExtent ke, T m) {
            List<T> mutList = this.mutations.get(ke);
            if (mutList == null) {
                mutList = new ArrayList<T>();
                this.mutations.put(ke, mutList);
            }
            mutList.add(m);
        }

        public Map<KeyExtent, List<T>> getMutations() {
            return this.mutations;
        }

        final String getSession() {
            return this.tserverSession;
        }
    }

    public static class TabletLocation
    implements Comparable<TabletLocation> {
        private static final WeakHashMap<String, WeakReference<String>> tabletLocs = new WeakHashMap();
        public final KeyExtent tablet_extent;
        public final String tablet_location;
        public final String tablet_session;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String dedupeLocation(String tabletLoc) {
            WeakHashMap<String, WeakReference<String>> weakHashMap = tabletLocs;
            synchronized (weakHashMap) {
                String loc;
                WeakReference<String> lref = tabletLocs.get(tabletLoc);
                if (lref != null && (loc = (String)lref.get()) != null) {
                    return loc;
                }
                tabletLocs.put(tabletLoc, new WeakReference<String>(tabletLoc));
                return tabletLoc;
            }
        }

        public TabletLocation(KeyExtent tablet_extent, String tablet_location, String session) {
            Preconditions.checkArgument((tablet_extent != null ? 1 : 0) != 0, (Object)"tablet_extent is null");
            Preconditions.checkArgument((tablet_location != null ? 1 : 0) != 0, (Object)"tablet_location is null");
            Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"session is null");
            this.tablet_extent = tablet_extent;
            this.tablet_location = TabletLocation.dedupeLocation(tablet_location);
            this.tablet_session = TabletLocation.dedupeLocation(session);
        }

        public boolean equals(Object o) {
            if (o instanceof TabletLocation) {
                TabletLocation otl = (TabletLocation)o;
                return this.tablet_extent.equals(otl.tablet_extent) && this.tablet_location.equals(otl.tablet_location) && this.tablet_session.equals(otl.tablet_session);
            }
            return false;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashcode is not implemented for class " + this.getClass().toString());
        }

        public String toString() {
            return "(" + this.tablet_extent + "," + this.tablet_location + "," + this.tablet_session + ")";
        }

        @Override
        public int compareTo(TabletLocation o) {
            int result = this.tablet_extent.compareTo(o.tablet_extent);
            if (result == 0 && (result = this.tablet_location.compareTo(o.tablet_location)) == 0) {
                result = this.tablet_session.compareTo(o.tablet_session);
            }
            return result;
        }
    }

    public static class TabletLocations {
        private final List<TabletLocation> locations;
        private final List<KeyExtent> locationless;

        public TabletLocations(List<TabletLocation> locations, List<KeyExtent> locationless) {
            this.locations = locations;
            this.locationless = locationless;
        }

        public List<TabletLocation> getLocations() {
            return this.locations;
        }

        public List<KeyExtent> getLocationless() {
            return this.locationless;
        }
    }

    private static class LocatorKey {
        String instanceId;
        Text tableName;

        LocatorKey(String instanceId, Text table) {
            this.instanceId = instanceId;
            this.tableName = table;
        }

        public int hashCode() {
            return this.instanceId.hashCode() + this.tableName.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof LocatorKey) {
                return this.equals((LocatorKey)o);
            }
            return false;
        }

        public boolean equals(LocatorKey lk) {
            return this.instanceId.equals(lk.instanceId) && this.tableName.equals((Object)lk.tableName);
        }
    }
}

